"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetServerAgentComponentStatuses = exports.AgentStatuses = exports.AGENT_UPDATE_LAST_CHECKIN_INTERVAL_MS = exports.AGENT_UPDATE_ACTIONS_INTERVAL_MS = exports.AGENT_TYPE_TEMPORARY = exports.AGENT_TYPE_PERMANENT = exports.AGENT_TYPE_EPHEMERAL = exports.AGENT_POLLING_THRESHOLD_MS = exports.AGENT_POLLING_REQUEST_TIMEOUT_MS = exports.AGENT_POLLING_REQUEST_TIMEOUT_MARGIN_MS = exports.AGENT_POLLING_INTERVAL = exports.AGENT_POLICY_ROLLOUT_RATE_LIMIT_REQUEST_PER_INTERVAL = exports.AGENT_POLICY_ROLLOUT_RATE_LIMIT_INTERVAL_MS = exports.AGENT_ACTIONS_RESULTS_INDEX = exports.AGENT_ACTIONS_INDEX = exports.AGENTS_PREFIX = exports.AGENTS_INDEX = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGENTS_PREFIX = exports.AGENTS_PREFIX = 'fleet-agents';
const AGENT_TYPE_PERMANENT = exports.AGENT_TYPE_PERMANENT = 'PERMANENT';
const AGENT_TYPE_EPHEMERAL = exports.AGENT_TYPE_EPHEMERAL = 'EPHEMERAL';
const AGENT_TYPE_TEMPORARY = exports.AGENT_TYPE_TEMPORARY = 'TEMPORARY';
const AGENT_POLLING_REQUEST_TIMEOUT_MS = exports.AGENT_POLLING_REQUEST_TIMEOUT_MS = 300000; // 5 minutes
const AGENT_POLLING_REQUEST_TIMEOUT_MARGIN_MS = exports.AGENT_POLLING_REQUEST_TIMEOUT_MARGIN_MS = 20000; // 20s

const AGENT_POLLING_THRESHOLD_MS = exports.AGENT_POLLING_THRESHOLD_MS = 30000;
const AGENT_POLLING_INTERVAL = exports.AGENT_POLLING_INTERVAL = 1000;
const AGENT_UPDATE_LAST_CHECKIN_INTERVAL_MS = exports.AGENT_UPDATE_LAST_CHECKIN_INTERVAL_MS = 30000;
const AGENT_UPDATE_ACTIONS_INTERVAL_MS = exports.AGENT_UPDATE_ACTIONS_INTERVAL_MS = 5000;
const AGENT_POLICY_ROLLOUT_RATE_LIMIT_INTERVAL_MS = exports.AGENT_POLICY_ROLLOUT_RATE_LIMIT_INTERVAL_MS = 1000;
const AGENT_POLICY_ROLLOUT_RATE_LIMIT_REQUEST_PER_INTERVAL = exports.AGENT_POLICY_ROLLOUT_RATE_LIMIT_REQUEST_PER_INTERVAL = 5;
const AGENTS_INDEX = exports.AGENTS_INDEX = '.fleet-agents';
const AGENT_ACTIONS_INDEX = exports.AGENT_ACTIONS_INDEX = '.fleet-actions';
const AGENT_ACTIONS_RESULTS_INDEX = exports.AGENT_ACTIONS_RESULTS_INDEX = '.fleet-actions-results';
const FleetServerAgentComponentStatuses = exports.FleetServerAgentComponentStatuses = ['STARTING', 'CONFIGURING', 'HEALTHY', 'DEGRADED', 'FAILED', 'STOPPING', 'STOPPED'];
const AgentStatuses = exports.AgentStatuses = ['offline', 'error', 'online', 'inactive', 'enrolling', 'unenrolling', 'unenrolled', 'updating', 'degraded'];