"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.method = exports.handler = void 0;
exports.register = register;
exports.rt = void 0;
var _configSchema = require("@kbn/config-schema");
var _api_routes = require("../api_routes");
var commonSchemas = _interopRequireWildcard(require("../common_schemas"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const method = exports.method = 'post';
const rt = exports.rt = {
  body: _configSchema.schema.object({
    name: commonSchemas.fileName,
    alt: commonSchemas.fileAlt,
    meta: commonSchemas.fileMeta,
    mimeType: _configSchema.schema.maybe(_configSchema.schema.string())
  })
};
const handler = async ({
  fileKind,
  files
}, req, res) => {
  const {
    fileService,
    security
  } = await files;
  const {
    body: {
      name,
      alt,
      meta,
      mimeType
    }
  } = req;
  const user = security === null || security === void 0 ? void 0 : security.authc.getCurrentUser(req);
  const file = await fileService.asCurrentUser().create({
    fileKind,
    name,
    alt,
    meta,
    user: user ? {
      name: user.username,
      id: user.profile_uid
    } : undefined,
    mime: mimeType
  });
  const body = {
    file: file.toJSON()
  };
  return res.ok({
    body
  });
};
exports.handler = handler;
function register(fileKindRouter, fileKind) {
  if (fileKind.http.create) {
    fileKindRouter[method]({
      path: _api_routes.FILES_API_ROUTES.fileKind.getCreateFileRoute(fileKind.id),
      validate: {
        ...rt
      },
      options: {
        tags: fileKind.http.create.tags
      }
    }, handler);
  }
}