"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoUploadForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _geo_file_picker = require("./geo_file_picker");
var _index_name_form = require("./index_name_form");
var _validate_index_name = require("../../validate_index_name");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GEO_FIELD_TYPE_OPTIONS = [{
  text: _public.ES_FIELD_TYPES.GEO_POINT,
  value: _public.ES_FIELD_TYPES.GEO_POINT
}, {
  text: _public.ES_FIELD_TYPES.GEO_SHAPE,
  value: _public.ES_FIELD_TYPES.GEO_SHAPE
}];
class GeoUploadForm extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      hasFile: false,
      isPointsOnly: false
    });
    (0, _defineProperty2.default)(this, "_onFileSelect", async onFileSelectParameters => {
      this.setState({
        hasFile: true,
        isPointsOnly: onFileSelectParameters.hasPoints && !onFileSelectParameters.hasShapes
      });
      this.props.onFileSelect(onFileSelectParameters);
      this.props.onIndexNameValidationStart();
      const indexNameError = await (0, _validate_index_name.validateIndexName)(onFileSelectParameters.indexName);
      if (!this._isMounted) {
        return;
      }
      this.props.onIndexNameValidationEnd();
      this.props.onIndexNameChange(onFileSelectParameters.indexName, indexNameError);
      const geoFieldType = onFileSelectParameters.hasPoints && !onFileSelectParameters.hasShapes ? _public.ES_FIELD_TYPES.GEO_POINT : _public.ES_FIELD_TYPES.GEO_SHAPE;
      this.props.onGeoFieldTypeSelect(geoFieldType);
    });
    (0, _defineProperty2.default)(this, "_onFileClear", () => {
      this.setState({
        hasFile: false,
        isPointsOnly: false
      });
      this.props.onFileClear();
      this.props.onIndexNameChange('');
    });
    (0, _defineProperty2.default)(this, "_onGeoFieldTypeSelect", event => {
      return this.props.onGeoFieldTypeSelect(event.target.value);
    });
    (0, _defineProperty2.default)(this, "_onSmallChunksChange", event => {
      this.props.onSmallChunksChange(event.target.checked);
    });
  }
  componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  _renderGeoFieldTypeSelect() {
    return this.state.hasFile && this.state.isPointsOnly ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.fileUpload.indexSettings.enterIndexTypeLabel', {
        defaultMessage: 'Index type'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-test-subj": "fileImportIndexSelect",
      options: GEO_FIELD_TYPE_OPTIONS,
      value: this.props.geoFieldType,
      onChange: this._onGeoFieldTypeSelect
    })) : null;
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_geo_file_picker.GeoFilePicker, {
      onSelect: this._onFileSelect,
      onClear: this._onFileClear
    }), this._renderGeoFieldTypeSelect(), this.state.hasFile ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_index_name_form.IndexNameForm, {
      indexName: this.props.indexName,
      indexNameError: this.props.indexNameError,
      onIndexNameChange: this.props.onIndexNameChange,
      onIndexNameValidationStart: this.props.onIndexNameValidationStart,
      onIndexNameValidationEnd: this.props.onIndexNameValidationEnd
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressedSwitch"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.fileUpload.smallChunks.tooltip', {
        defaultMessage: 'Use to alleviate request timeout failures.'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.fileUpload.smallChunks.switchLabel', {
        defaultMessage: 'Upload file in smaller chunks'
      }),
      checked: this.props.smallChunks,
      onChange: this._onSmallChunksChange,
      compressed: true
    })))) : null);
  }
}
exports.GeoUploadForm = GeoUploadForm;