"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LINES_MARKER_SIZE = exports.AnnotationIcon = void 0;
exports.Marker = Marker;
exports.MarkerBody = MarkerBody;
exports.isAnnotationConfig = exports.getLinesCausedPaddings = void 0;
exports.mapVerticalToHorizontalPlacement = mapVerticalToHorizontalPlacement;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _components = require("../components");
var _icon = require("./icon");
var _axes_configuration = require("./axes_configuration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LINES_MARKER_SIZE = exports.LINES_MARKER_SIZE = 20;
const isExtendedDecorationConfig = config => config !== null && config !== void 0 && config.iconPosition ? true : false;
const isAnnotationConfig = config => {
  return 'isGrouped' in config;
};

// Note: it does not take into consideration whether the reference line is in view or not
exports.isAnnotationConfig = isAnnotationConfig;
const getLinesCausedPaddings = (visualConfigs, axesMap, shouldRotate) => {
  // collect all paddings for the 4 axis: if any text is detected double it.
  const paddings = {};
  const icons = {};
  visualConfigs === null || visualConfigs === void 0 ? void 0 : visualConfigs.forEach(config => {
    if (!config) {
      return;
    }
    const {
      position,
      icon,
      textVisibility
    } = config;
    const iconPosition = isExtendedDecorationConfig(config) ? config.iconPosition : undefined;
    const isLabelVisible = textVisibility && (isAnnotationConfig(config) ? config.label : true);
    if (position && ((0, _icon.hasIcon)(icon) || isLabelVisible)) {
      const placement = (0, _components.getBaseIconPlacement)(iconPosition, axesMap, (0, _axes_configuration.getOriginalAxisPosition)(position, shouldRotate));
      paddings[placement] = Math.max(paddings[placement] || 0, LINES_MARKER_SIZE * (isLabelVisible ? 2 : 1) // double the padding size if there's text
      );
      icons[placement] = (icons[placement] || 0) + ((0, _icon.hasIcon)(icon) ? 1 : 0);
    }
  });
  // post-process the padding based on the icon presence:
  // if no icon is present for the placement, just reduce the padding
  Object.keys(paddings).forEach(placement => {
    if (!icons[placement]) {
      paddings[placement] = LINES_MARKER_SIZE;
    }
  });
  return paddings;
};
exports.getLinesCausedPaddings = getLinesCausedPaddings;
function mapVerticalToHorizontalPlacement(placement) {
  switch (placement) {
    case _charts.Position.Top:
      return _charts.Position.Right;
    case _charts.Position.Bottom:
      return _charts.Position.Left;
    case _charts.Position.Left:
      return _charts.Position.Bottom;
    case _charts.Position.Right:
      return _charts.Position.Top;
  }
}
function MarkerBody({
  label,
  isHorizontal
}) {
  if (!label) {
    return null;
  }
  if (isHorizontal) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "eui-textTruncate",
      style: {
        maxWidth: LINES_MARKER_SIZE * 3
      },
      "data-test-subj": "xyVisAnnotationText"
    }, label);
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "xyDecorationRotatedWrapper",
    "data-test-subj": "xyVisAnnotationText",
    style: {
      width: LINES_MARKER_SIZE
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textTruncate xyDecorationRotatedWrapper__label",
    style: {
      maxWidth: LINES_MARKER_SIZE * 3
    }
  }, label));
}
function NumberIcon({
  number
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround",
    className: "xyAnnotationNumberIcon",
    "data-test-subj": "xyVisGroupedAnnotationIcon",
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "ghost",
    className: "xyAnnotationNumberIcon__text"
  }, number < 10 ? number : `9+`));
}
const isNumericalString = value => !isNaN(Number(value));
const AnnotationIcon = ({
  type,
  rotateClassName = '',
  isHorizontal,
  renderedInChart,
  ...rest
}) => {
  if (isNumericalString(type)) {
    return /*#__PURE__*/_react.default.createElement(NumberIcon, {
      number: Number(type)
    });
  }
  const iconConfig = _icon.iconSet.find(i => i.value === type);
  if (!iconConfig) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({}, rest, {
    "data-test-subj": "xyVisAnnotationIcon",
    type: iconConfig.icon || type,
    className: iconConfig.shouldRotate ? rotateClassName : undefined
  }));
};
exports.AnnotationIcon = AnnotationIcon;
function Marker({
  config,
  isHorizontal,
  hasReducedPadding,
  label,
  rotateClassName
}) {
  if ((0, _icon.hasIcon)(config.icon)) {
    return /*#__PURE__*/_react.default.createElement(AnnotationIcon, {
      type: config.icon,
      rotateClassName: rotateClassName,
      renderedInChart: true
    });
  }

  // if there's some text, check whether to show it as marker, or just show some padding for the icon
  if (config.textVisibility) {
    if (hasReducedPadding) {
      return /*#__PURE__*/_react.default.createElement(MarkerBody, {
        label: label,
        isHorizontal: isHorizontal
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "empty"
    });
  }
  return null;
}