"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShapeComponent = ShapeComponent;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reusable = require("../reusable");
var _lib = require("../../../common/lib");
var _ = require("../..");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function ShapeComponent({
  onLoaded,
  parentNode,
  shape: shapeType,
  fill,
  border,
  borderWidth,
  maintainAspect
}) {
  const parentNodeDimensions = (0, _eui.useResizeObserver)(parentNode);
  const [dimensions, setDimensions] = (0, _react.useState)({
    width: parentNode.offsetWidth,
    height: parentNode.offsetHeight
  });
  const [shapeData, setShapeData] = (0, _react.useState)((0, _reusable.getDefaultShapeData)());
  (0, _react.useEffect)(() => {
    setDimensions({
      width: parentNode.offsetWidth,
      height: parentNode.offsetHeight
    });
    onLoaded();
  }, [parentNode, parentNodeDimensions, onLoaded]);
  const shapeRef = (0, _react.useCallback)(node => {
    if (node !== null) setShapeData(node.getData());
  }, []);
  const strokeWidth = Math.max(borderWidth, 0);
  const shapeContentAttributes = {
    strokeWidth: String(strokeWidth),
    vectorEffect: 'non-scaling-stroke',
    strokeMiterlimit: '999'
  };
  if (fill) shapeContentAttributes.fill = fill;
  if (border) shapeContentAttributes.stroke = border;
  const {
    width,
    height
  } = dimensions;
  const shapeAttributes = {
    width,
    height,
    overflow: 'visible',
    preserveAspectRatio: maintainAspect ? 'xMidYMid meet' : 'none',
    viewBox: (0, _lib.getViewBox)(shapeData.viewBox, {
      borderOffset: strokeWidth,
      width,
      height
    })
  };
  parentNode.style.lineHeight = '0';
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "shapeAligner"
  }, /*#__PURE__*/_react.default.createElement(_.ShapeDrawerComponent, {
    shapeType: shapeType,
    shapeContentAttributes: shapeContentAttributes,
    shapeAttributes: shapeAttributes,
    ref: shapeRef
  }));
}