"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMetricVisRenderer = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _react2 = require("@emotion/react");
var _analytics = require("@kbn/analytics");
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _common = require("../../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
async function metricFilterable(dimensions, table, hasCompatibleActions) {
  var _dimensions$breakdown;
  const column = (0, _utils.getColumnByAccessor)((_dimensions$breakdown = dimensions.breakdownBy) !== null && _dimensions$breakdown !== void 0 ? _dimensions$breakdown : dimensions.metric, table.columns);
  const colIndex = table.columns.indexOf(column);
  const value = column ? table.rows[0][column.id] : undefined;
  return Boolean(await (hasCompatibleActions === null || hasCompatibleActions === void 0 ? void 0 : hasCompatibleActions({
    name: 'filter',
    data: {
      data: [{
        table,
        column: colIndex,
        row: 0,
        value
      }]
    }
  })));
}
const getMetricVisRenderer = deps => {
  return () => ({
    name: _common.EXPRESSION_METRIC_NAME,
    displayName: 'metric visualization',
    reuseDomNode: true,
    render: async (domNode, {
      visData,
      visConfig,
      overrides
    }, handlers) => {
      var _handlers$hasCompatib;
      const {
        core,
        plugins
      } = deps.getStartDeps();
      handlers.onDestroy(() => {
        (0, _reactDom.unmountComponentAtNode)(domNode);
      });
      const filterable = visData.rows.length ? await metricFilterable(visConfig.dimensions, visData, (_handlers$hasCompatib = handlers.hasCompatibleActions) === null || _handlers$hasCompatib === void 0 ? void 0 : _handlers$hasCompatib.bind(handlers)) : false;
      const renderComplete = () => {
        const executionContext = handlers.getExecutionContext();
        const containerType = (0, _chartExpressionsCommon.extractContainerType)(executionContext);
        const visualizationType = (0, _chartExpressionsCommon.extractVisualizationType)(executionContext);
        if (containerType && visualizationType) {
          var _plugins$usageCollect;
          (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, [`render_${visualizationType}_metric`]);
        }
        handlers.done();
      };
      const {
        MetricVis
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../components/metric_vis')));
      (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
        theme$: core.theme.theme$
      }, /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "mtrVis",
        css: (0, _react2.css)`
              height: 100%;
              width: 100%;
              display: flex;
              align-items: center;
              justify-content: center;
            `
      }, /*#__PURE__*/_react.default.createElement(MetricVis, {
        data: visData,
        config: visConfig,
        renderComplete: renderComplete,
        fireEvent: handlers.event,
        filterable: filterable,
        overrides: overrides
      }))), domNode);
    }
  });
};
exports.getMetricVisRenderer = getMetricVisRenderer;