"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMobileKPIDistributionConfig = getMobileKPIDistributionConfig;
var _constants = require("../constants");
var _utils = require("../utils");
var _elasticsearch_fieldnames = require("../constants/elasticsearch_fieldnames");
var _labels = require("../constants/labels");
var _mobile_fields = require("./mobile_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getMobileKPIDistributionConfig({
  dataView
}) {
  return {
    reportType: _constants.ReportTypes.DISTRIBUTION,
    defaultSeriesType: 'bar',
    seriesTypes: ['line', 'bar'],
    xAxisColumn: {
      sourceField: _constants.REPORT_METRIC_FIELD
    },
    yAxisColumns: [{
      sourceField: _constants.RECORDS_FIELD
    }],
    hasOperationType: false,
    filterFields: [...Object.keys(_mobile_fields.MobileFields), _constants.LABEL_FIELDS_FILTER],
    breakdownFields: Object.keys(_mobile_fields.MobileFields),
    baseFilters: [...(0, _utils.buildPhrasesFilter)('agent.name', ['iOS/swift', 'open-telemetry/swift'], dataView)],
    labels: {
      ..._constants.FieldLabels,
      ..._mobile_fields.MobileFields,
      [_elasticsearch_fieldnames.SERVICE_NAME]: _labels.MOBILE_APP
    },
    definitionFields: [_elasticsearch_fieldnames.SERVICE_NAME, _elasticsearch_fieldnames.SERVICE_ENVIRONMENT],
    metricOptions: [{
      label: _labels.RESPONSE_LATENCY,
      field: _elasticsearch_fieldnames.TRANSACTION_DURATION,
      id: _elasticsearch_fieldnames.TRANSACTION_DURATION,
      columnFilters: [{
        language: 'kuery',
        query: `${_elasticsearch_fieldnames.PROCESSOR_EVENT}: transaction`
      }]
    }, {
      label: _labels.SYSTEM_MEMORY_USAGE,
      field: _elasticsearch_fieldnames.METRIC_SYSTEM_MEMORY_USAGE,
      id: _elasticsearch_fieldnames.METRIC_SYSTEM_MEMORY_USAGE,
      columnFilters: [{
        language: 'kuery',
        query: `${_elasticsearch_fieldnames.PROCESSOR_EVENT}: metric`
      }]
    }, {
      label: _labels.CPU_USAGE,
      field: _elasticsearch_fieldnames.METRIC_SYSTEM_CPU_USAGE,
      id: _elasticsearch_fieldnames.METRIC_SYSTEM_CPU_USAGE,
      columnFilters: [{
        language: 'kuery',
        query: `${_elasticsearch_fieldnames.PROCESSOR_EVENT}: metric`
      }]
    }]
  };
}