"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultConfigs = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultConfigs = ({
  reportType,
  dataType,
  spaceId,
  dataView,
  reportConfigMap
}) => {
  var _reportConfigMap$data;
  let configResult;
  (_reportConfigMap$data = reportConfigMap[dataType]) === null || _reportConfigMap$data === void 0 ? void 0 : _reportConfigMap$data.some(fn => {
    const config = fn({
      dataView,
      spaceId
    });
    if (config.reportType === reportType) {
      configResult = config;
    }
    return config.reportType === reportType;
  });
  if (!configResult) {
    // not a user facing error, more of a dev focused error
    throw new Error(`No report config provided for dataType: ${dataType} and reportType: ${reportType}`);
  }
  return configResult;
};
exports.getDefaultConfigs = getDefaultConfigs;