"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.retrieveFields = retrieveFields;
exports.retrieveFieldsFromStringSources = retrieveFieldsFromStringSources;
exports.retrieveMetadataFields = retrieveMetadataFields;
exports.retrievePolicies = retrievePolicies;
exports.retrievePoliciesFields = retrievePoliciesFields;
exports.retrieveSources = retrieveSources;
var _helpers = require("../shared/helpers");
var _resources_helpers = require("../shared/resources_helpers");
var _helpers2 = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function retrieveFields(queryString, commands, callbacks) {
  if (!callbacks || commands.length < 1) {
    return new Map();
  }
  if (commands[0].name === 'row') {
    return new Map();
  }
  const customQuery = (0, _helpers2.buildQueryForFieldsFromSource)(queryString, commands);
  return await (0, _resources_helpers.getFieldsByTypeHelper)(customQuery, callbacks).getFieldsMap();
}
async function retrievePolicies(commands, callbacks) {
  if (!callbacks || commands.every(({
    name
  }) => name !== 'enrich')) {
    return new Map();
  }
  const policies = await (0, _resources_helpers.getPolicyHelper)(callbacks).getPolicies();
  return (0, _helpers.createMapFromList)(policies);
}
async function retrieveSources(commands, callbacks) {
  if (!callbacks || commands.length < 1) {
    return new Set();
  }
  if (['row', 'show', 'meta'].includes(commands[0].name)) {
    return new Set();
  }
  const sources = await (0, _resources_helpers.getSourcesHelper)(callbacks)();
  return new Set(sources.map(({
    name
  }) => name));
}
async function retrievePoliciesFields(commands, policies, callbacks) {
  if (!callbacks) {
    return new Map();
  }
  const enrichCommands = commands.filter(({
    name
  }) => name === 'enrich');
  if (!enrichCommands.length) {
    return new Map();
  }
  const policyNames = enrichCommands.map(({
    args
  }) => (0, _helpers.isSourceItem)(args[0]) ? args[0].name : undefined).filter(_helpers.nonNullable);
  if (!policyNames.every(name => policies.has(name))) {
    return new Map();
  }
  const customQuery = (0, _helpers2.buildQueryForFieldsInPolicies)(policyNames.map(name => policies.get(name)));
  return await (0, _resources_helpers.getFieldsByTypeHelper)(customQuery, callbacks).getFieldsMap();
}
async function retrieveMetadataFields(callbacks) {
  if (!callbacks || !callbacks.getMetaFields) {
    return new Set();
  }
  const fields = await callbacks.getMetaFields();
  return new Set(fields);
}
async function retrieveFieldsFromStringSources(queryString, commands, callbacks) {
  if (!callbacks || !(callbacks !== null && callbacks !== void 0 && callbacks.getMetaFields)) {
    return new Map();
  }
  const customQuery = (0, _helpers2.buildQueryForFieldsForStringSources)(queryString, commands);
  return await (0, _resources_helpers.getFieldsByTypeHelper)(customQuery, callbacks).getFieldsMap();
}