"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataViewFieldSubtypeMulti = getDataViewFieldSubtypeMulti;
exports.getDataViewFieldSubtypeNested = getDataViewFieldSubtypeNested;
exports.getTimeZoneFromSettings = getTimeZoneFromSettings;
exports.isDataViewFieldSubtypeMulti = isDataViewFieldSubtypeMulti;
exports.isDataViewFieldSubtypeNested = isDataViewFieldSubtypeNested;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */
function getTimeZoneFromSettings(dateFormatTZ) {
  const detectedTimezone = _momentTimezone.default.tz.guess();
  return dateFormatTZ === 'Browser' ? detectedTimezone : dateFormatTZ;
}
function isDataViewFieldSubtypeNested(field) {
  var _subTypeNested$nested;
  const subTypeNested = field === null || field === void 0 ? void 0 : field.subType;
  return !!(subTypeNested !== null && subTypeNested !== void 0 && (_subTypeNested$nested = subTypeNested.nested) !== null && _subTypeNested$nested !== void 0 && _subTypeNested$nested.path);
}
function getDataViewFieldSubtypeNested(field) {
  return isDataViewFieldSubtypeNested(field) ? field.subType : undefined;
}
function isDataViewFieldSubtypeMulti(field) {
  var _subTypeNested$multi;
  const subTypeNested = field === null || field === void 0 ? void 0 : field.subType;
  return !!(subTypeNested !== null && subTypeNested !== void 0 && (_subTypeNested$multi = subTypeNested.multi) !== null && _subTypeNested$multi !== void 0 && _subTypeNested$multi.parent);
}
function getDataViewFieldSubtypeMulti(field) {
  return isDataViewFieldSubtypeMulti(field) ? field.subType : undefined;
}