"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAggregateQueryMode = getAggregateQueryMode;
exports.getLanguageDisplayName = getLanguageDisplayName;
exports.isOfAggregateQueryType = isOfAggregateQueryType;
exports.isOfEsqlQueryType = isOfEsqlQueryType;
exports.isOfQueryType = isOfQueryType;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Checks if the query is of type Query
function isOfQueryType(arg) {
  return Boolean(arg && 'query' in arg);
}

// Checks if the query is of type AggregateQuery
// currently only supports the sql query type
// should be enhanced to support other query types
function isOfAggregateQueryType(query) {
  return Boolean(query && ('sql' in query || 'esql' in query));
}

/**
 * True if the query is of type AggregateQuery and is of type esql, false otherwise.
 */
function isOfEsqlQueryType(query) {
  return Boolean(query && 'esql' in query && !('sql' in query));
}

// returns the language of the aggregate Query, sql, esql etc
function getAggregateQueryMode(query) {
  return Object.keys(query)[0];
}
function getLanguageDisplayName(language) {
  const displayName = language && language === 'esql' ? 'es|ql' : language !== null && language !== void 0 ? language : 'es|ql';
  return displayName.toUpperCase();
}