"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExampleResultDetailCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../../../constants");
var _custom_source_icon = require("./custom_source_icon");
var _display_settings_logic = require("./display_settings_logic");
var _title_field = require("./title_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExampleResultDetailCard = () => {
  const {
    sourceName,
    searchResultConfig: {
      titleField,
      urlField,
      color,
      detailFields
    },
    titleFieldHover,
    urlFieldHover,
    exampleDocuments
  } = (0, _kea.useValues)(_display_settings_logic.DisplaySettingsLogic);
  const result = exampleDocuments[0];
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "example-result-detail-card",
    "data-test-subj": "ExampleResultDetailCard"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "example-result-detail-card__header"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "example-result-detail-card__border",
    style: {
      backgroundColor: color
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "example-result-detail-card__source-name"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_custom_source_icon.CustomSourceIcon, {
    color: color
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, sourceName))), /*#__PURE__*/_react.default.createElement("div", {
    className: "example-result-content"
  }, /*#__PURE__*/_react.default.createElement(_title_field.TitleField, {
    titleFieldHover: titleFieldHover,
    titleField: titleField,
    result: result
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('example-result-content__url', {
      'example-result-field-hover': urlFieldHover
    })
  }, urlField ? /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textTruncate"
  }, result[urlField]) : /*#__PURE__*/_react.default.createElement("span", {
    className: "example-result-content-placeholder",
    "data-test-subj": "DefaultUrlLabel"
  }, _constants.URL_LABEL)))), /*#__PURE__*/_react.default.createElement("div", {
    className: "example-result-detail-card__content"
  }, detailFields.length > 0 ? detailFields.map(({
    fieldName,
    label
  }, index) => {
    const value = result[fieldName];
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "example-result-detail-card__field",
      key: index,
      "data-test-subj": "DetailField"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", null, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "eui-textBreakWord"
    }, value)));
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })));
};
exports.ExampleResultDetailCard = ExampleResultDetailCard;