"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfiguredSourcesList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react_router_helpers = require("../../../../../shared/react_router_helpers");
var _source_icon = require("../../../../components/shared/source_icon");
var _routes = require("../../../../routes");
var _source_data = require("../../source_data");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfiguredSourcesList = ({
  sources,
  isOrganization
}) => {
  const unConnectedTooltip = /*#__PURE__*/_react.default.createElement("span", {
    className: "source-card-configured__not-connected-tooltip",
    "data-test-subj": "UnConnectedTooltip"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _constants.CONFIGURED_SOURCES_LIST_UNCONNECTED_TOOLTIP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
    iconType: "tokenException",
    color: "orange",
    shape: "circle",
    fill: "light"
  })));
  const accountOnlyTooltip = /*#__PURE__*/_react.default.createElement("span", {
    className: "source-card-configured__not-connected-tooltip",
    "data-test-subj": "AccountOnlyTooltip"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _constants.CONFIGURED_SOURCES_LIST_ACCOUNT_ONLY_TOOLTIP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
    iconType: "tokenException",
    color: "green",
    shape: "circle",
    fill: "light"
  })));
  const visibleSources = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3,
    gutterSize: "m",
    className: "source-grid-configured"
  }, sources.map((sourceData, i) => {
    const {
      connected,
      accountContextOnly,
      name,
      serviceType,
      isBeta,
      baseServiceType
    } = sourceData;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: i
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      className: "organizational-content-source-item",
      "data-test-subj": "ConfiguredSourcesListItem"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      title: "",
      betaBadgeProps: isBeta ? {
        label: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configuredSourcesList.betaBadge', {
          defaultMessage: 'Beta'
        })
      } : undefined,
      paddingSize: "none",
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
      color: "plain",
      hasShadow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      direction: "column",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_source_icon.SourceIcon, {
      serviceType: baseServiceType !== null && baseServiceType !== void 0 ? baseServiceType : serviceType,
      name: name,
      size: "xxl"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h4", null, name, !connected && !accountContextOnly && isOrganization && unConnectedTooltip, accountContextOnly && isOrganization && accountOnlyTooltip))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
      color: "subdued",
      paddingSize: "none"
    }, (!isOrganization || isOrganization && !accountContextOnly) && /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
      className: "eui-fullWidth",
      to: `${(0, _routes.getSourcesPath)((0, _routes.getAddPath)(serviceType), isOrganization)}/${(0, _source_data.hasMultipleConnectorOptions)(serviceType) && isOrganization ? 'choice' : ''}`
    }, !connected ? _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configuredSources.connectButton', {
      defaultMessage: 'Connect'
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configuredSources.connectAnotherButton', {
      defaultMessage: 'Connect another'
    })) || /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      className: "eui-fullWidth",
      isDisabled: true
    }, _constants.ADD_SOURCE_ORG_SOURCES_TITLE))))));
  }));
  const emptyState = /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "ConfiguredSourceEmptyState"
  }, _constants.CONFIGURED_SOURCES_EMPTY_STATE);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _constants.CONFIGURED_SOURCES_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _constants.CONFIGURED_SOURCES_EMPTY_BODY)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), sources.length > 0 ? visibleSources : emptyState, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }));
};
exports.ConfiguredSourcesList = ConfiguredSourcesList;