"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BodyRow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _cell = require("./cell");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BodyRow = ({
  columns,
  item,
  additionalProps,
  leftAction,
  errors = [],
  rowIdentifier
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "reorderableTableRow"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
    "data-test-subj": "row",
    alignItems: "center"
  }, additionalProps || {}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, leftAction && /*#__PURE__*/_react.default.createElement(_cell.Cell, _constants.DRAGGABLE_UX_STYLE, leftAction), rowIdentifier && /*#__PURE__*/_react.default.createElement(_cell.Cell, (0, _extends2.default)({}, _constants.DRAGGABLE_UX_STYLE, {
    flexBasis: "24px"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
    size: "m",
    iconType: () => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("strong", null, rowIdentifier))
  })), columns.map((column, columnIndex) => /*#__PURE__*/_react.default.createElement(_cell.Cell, {
    key: `table_row_cell_${columnIndex}`,
    alignItems: column.alignItems,
    flexBasis: column.flexBasis,
    flexGrow: column.flexGrow
  }, column.render(item)))))), errors.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, errors.map((errorMessage, errorMessageIndex) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: errorMessageIndex
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    size: "s",
    color: "danger",
    title: errorMessage
  })))));
};
exports.BodyRow = BodyRow;