"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaType = exports.InternalSchemaType = exports.IgnoreSchemaTypes = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Schema types
 */
let SchemaType = exports.SchemaType = /*#__PURE__*/function (SchemaType) {
  SchemaType["Text"] = "text";
  SchemaType["Number"] = "number";
  SchemaType["Geolocation"] = "geolocation";
  SchemaType["Date"] = "date";
  SchemaType["Nested"] = "nested";
  return SchemaType;
}({}); // Certain Schema types may have to be ignored from showing up, these types could be added to this list
const IgnoreSchemaTypes = exports.IgnoreSchemaTypes = [SchemaType.Nested];
// Certain API endpoints will use these internal type names, which map to the external names above
let InternalSchemaType = exports.InternalSchemaType = /*#__PURE__*/function (InternalSchemaType) {
  InternalSchemaType["String"] = "string";
  InternalSchemaType["Float"] = "float";
  InternalSchemaType["Location"] = "location";
  InternalSchemaType["Date"] = "date";
  InternalSchemaType["Nested"] = "nested";
  return InternalSchemaType;
}({});
/**
 * Schema conflict types
 */
// This is a mapping of schema field types ("text", "number", "geolocation", "date")
// to the names of source engines which utilize that type
// For now these values are SchemaConflictFieldTypes, but in the near future will be SchemaConflict
// once we implement schema conflict resolution
/**
 * Indexing job / errors types
 */