"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointsHeaderAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _fetch_api_keys_logic = require("../../enterprise_search_overview/api/fetch_api_keys_logic");
var _create_api_key_flyout = require("../api_key/create_api_key_flyout");
var _kibana = require("../kibana");
var _endpoint_icon = require("./endpoint_icon");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointsHeaderAction = ({
  children
}) => {
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const {
    cloud,
    esConfig,
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    makeRequest
  } = (0, _kea.useActions)(_fetch_api_keys_logic.FetchApiKeysAPILogic);
  const {
    data
  } = (0, _kea.useValues)(_fetch_api_keys_logic.FetchApiKeysAPILogic);
  const [isFlyoutOpen, setIsFlyoutOpen] = (0, _react.useState)(false);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  (0, _react.useEffect)(() => makeRequest({}), []);
  const COPIED_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.pageTemplate.apiKey.copied', {
    defaultMessage: 'Copied'
  });
  const apiKeys = (data === null || data === void 0 ? void 0 : data.api_keys) || [];
  const cloudId = cloud === null || cloud === void 0 ? void 0 : cloud.cloudId;
  const elasticsearchEndpoint = esConfig.elasticsearch_host;
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: _endpoint_icon.EndpointIcon,
    size: "s",
    onClick: () => setPopoverOpen(!isPopoverOpen)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.pageTemplate.endpointsButtonLabel', {
    defaultMessage: 'Endpoints & API keys'
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, Boolean(children) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isFlyoutOpen && /*#__PURE__*/_react.default.createElement(_create_api_key_flyout.CreateApiKeyFlyout, {
    onClose: () => setIsFlyoutOpen(false)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setPopoverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    css: (0, _react2.css)`
                max-width: calc(${euiTheme.size.xxxxl} * 4);
              `,
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "endpoint"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.pageTemplate.apiKey.elasticsearchEndpoint', {
      defaultMessage: 'Elasticsearch endpoint:'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      justifyContent: "flexEnd",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      css: (0, _react2.css)`
                          overflow-wrap: anywhere;
                        `
    }, elasticsearchEndpoint)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: elasticsearchEndpoint || '',
      afterMessage: COPIED_LABEL
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: copy,
      iconType: "copyClipboard",
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.overview.pageTemplate.apiKey.copyApiEndpoint', {
        defaultMessage: 'Copy Elasticsearch endpoint to clipboard.'
      })
    }))))), ...(Boolean(cloudId) ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "cloudId"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.cloudId', {
      defaultMessage: 'Cloud ID:'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      justifyContent: "flexEnd",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      css: (0, _react2.css)`
                                overflow-wrap: anywhere;
                              `
    }, cloudId)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: cloudId || '',
      afterMessage: COPIED_LABEL
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: copy,
      iconType: "copyClipboard",
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.overview.apiKey.copyCloudID', {
        defaultMessage: 'Copy cloud ID to clipboard.'
      })
    })))))] : []), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "apiKeys"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      justifyContent: "flexEnd",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.endpointsHeader.apiKey.activeKeys",
      defaultMessage: "{number} active API keys",
      values: {
        number: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: apiKeys.length > 0 ? 'success' : 'warning',
          "data-test-subj": "api-keys-count-badge"
        }, apiKeys.length)
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.pageTemplate.apiKey.manageLabel', {
        defaultMessage: 'Manage'
      }),
      iconType: "gear",
      onClick: () => navigateToUrl('/app/management/security/api_keys', {
        shouldNotCreateHref: true
      })
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xs",
      key: "rule"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "createApiKey"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "plusInCircle",
      size: "s",
      onClick: () => {
        setIsFlyoutOpen(true);
        setPopoverOpen(false);
      },
      "data-test-subj": "new-api-key-button",
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.pageTemplate.apiKey.newButtonLabel', {
      defaultMessage: 'New API key'
    }))))]
  })))));
};
exports.EndpointsHeaderAction = EndpointsHeaderAction;