"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountKibanaLogic = exports.KibanaLogic = void 0;
var _kea = require("kea");
var _constants = require("@kbn/search-api-panels/constants");
var _http = require("../http");
var _react_router_helpers = require("../react_router_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KibanaLogic = exports.KibanaLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'kibana_logic'],
  reducers: ({
    props
  }) => ({
    application: [props.application, {}],
    capabilities: [props.capabilities, {}],
    charts: [props.charts || null, {}],
    cloud: [props.cloud || null, {}],
    config: [props.config || null, {}],
    connectorTypes: [props.connectorTypes || [], {}],
    consolePlugin: [props.console || null, {}],
    data: [props.data || null, {}],
    esConfig: [props.esConfig || {
      elasticsearch_host: _constants.ELASTICSEARCH_URL_PLACEHOLDER
    }, {}],
    guidedOnboarding: [props.guidedOnboarding || null, {}],
    history: [props.history, {}],
    indexMappingComponent: [props.indexMappingComponent || null, {}],
    isSidebarEnabled: [props.isSidebarEnabled, {}],
    lens: [props.lens || null, {}],
    ml: [props.ml || null, {}],
    navigateToUrl: [(url, options) => {
      const deps = {
        history: props.history,
        http: _http.HttpLogic.values.http
      };
      const href = (0, _react_router_helpers.createHref)(url, deps, options);
      return props.navigateToUrl(href);
    }, {}],
    productAccess: [props.productAccess, {}],
    productFeatures: [props.productFeatures, {}],
    renderHeaderActions: [props.renderHeaderActions, {}],
    searchPlayground: [props.searchPlayground || null, {}],
    security: [props.security || null, {}],
    setBreadcrumbs: [props.setBreadcrumbs, {}],
    setChromeIsVisible: [props.setChromeIsVisible, {}],
    setDocTitle: [props.setDocTitle, {}],
    share: [props.share || null, {}],
    uiSettings: [props.uiSettings, {}],
    user: [props.user || null, {}]
  }),
  selectors: ({
    selectors
  }) => ({
    isCloud: [() => [selectors.cloud], cloud => Boolean(cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled)]
  })
});
const mountKibanaLogic = props => {
  KibanaLogic(props);
  const unmount = KibanaLogic.mount();
  return unmount;
};
exports.mountKibanaLogic = mountKibanaLogic;