"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlashMessages = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("./constants");
var _flash_messages_logic = require("./flash_messages_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlashMessages = ({
  children
}) => {
  const {
    messages
  } = (0, _kea.useValues)(_flash_messages_logic.FlashMessagesLogic);
  return /*#__PURE__*/_react.default.createElement("div", {
    "aria-live": "polite",
    "data-test-subj": "FlashMessages"
  }, messages.map(({
    type,
    message,
    description,
    iconType
  }, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: _constants.FLASH_MESSAGE_TYPES[type].color,
    iconType: iconType !== null && iconType !== void 0 ? iconType : _constants.FLASH_MESSAGE_TYPES[type].iconType,
    title: message
  }, description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))), children);
};
exports.FlashMessages = FlashMessages;