"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _health_colors = require("../../../shared/constants/health_colors");
var _encode_path_params = require("../../../shared/encode_path_params");
var _kibana = require("../../../shared/kibana");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _eui_components = require("../../../shared/react_router_helpers/eui_components");
var _routes = require("../../routes");
var _indices = require("../../utils/indices");
var _ingestion_status_helpers = require("../../utils/ingestion_status_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndicesTable = ({
  indices,
  isLoading,
  meta,
  onChange,
  onDelete
}) => {
  const {
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.name.columnTitle', {
      defaultMessage: 'Index name'
    }),
    render: name => /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
      "data-test-subj": "search-index-link",
      to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_PATH, {
        indexName: name
      })
    }, name),
    sortable: true,
    width: '33%'
  }, {
    field: 'health',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.health.columnTitle', {
      defaultMessage: 'Index health'
    }),
    render: health => {
      var _healthColorsMap$heal;
      return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "dot",
        color: (_healthColorsMap$heal = _health_colors.healthColorsMap[health]) !== null && _healthColorsMap$heal !== void 0 ? _healthColorsMap$heal : ''
      }), "\xA0", health !== null && health !== void 0 ? health : '-');
    },
    sortable: true,
    truncateText: true
  }, {
    field: 'count',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.docsCount.columnTitle', {
      defaultMessage: 'Docs count'
    }),
    sortable: true,
    truncateText: true
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionName.columnTitle', {
      defaultMessage: 'Ingestion name'
    }),
    render: index => {
      var _ref, _NATIVE_CONNECTOR_DEF;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, (_ref = (0, _indices.isConnectorIndex)(index) && index.connector.service_type && ((_NATIVE_CONNECTOR_DEF = _searchConnectors.NATIVE_CONNECTOR_DEFINITIONS[index.connector.service_type]) === null || _NATIVE_CONNECTOR_DEF === void 0 ? void 0 : _NATIVE_CONNECTOR_DEF.name)) !== null && _ref !== void 0 ? _ref : '--');
    },
    truncateText: true
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionMethod.columnTitle', {
      defaultMessage: 'Ingestion method'
    }),
    render: index => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, (0, _indices.isConnectorIndex)(index) && index.connector.is_native ? _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionmethod.nativeConnector', {
      defaultMessage: 'Native connector'
    }) : (0, _indices.ingestionMethodToText)(index.ingestionMethod))
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionStatus.columnTitle', {
      defaultMessage: 'Ingestion status'
    }),
    render: index => {
      const overviewPath = (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_PATH, {
        indexName: index.name
      });
      const label = (0, _ingestion_status_helpers.ingestionStatusToText)(index.ingestionStatus);
      return /*#__PURE__*/_react.default.createElement(_eui_components.EuiBadgeTo, {
        to: overviewPath,
        label: label,
        color: (0, _ingestion_status_helpers.ingestionStatusToColor)(index.ingestionStatus)
      });
    },
    truncateText: true
  }, {
    actions: [{
      description: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.actions.viewIndex.title', {
        defaultMessage: 'View this index'
      }),
      icon: 'eye',
      isPrimary: false,
      name: index => _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.actions.viewIndex.caption', {
        defaultMessage: 'View index {indexName}',
        values: {
          indexName: index.name
        }
      }),
      onClick: index => navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_PATH, {
        indexName: index.name
      })),
      type: 'icon'
    }, {
      color: 'danger',
      description: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.actions.deleteIndex.title', {
        defaultMessage: 'Delete this index'
      }),
      icon: 'trash',
      isPrimary: false,
      name: index => _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.actions.deleteIndex.caption', {
        defaultMessage: 'Delete index {indexName}',
        values: {
          indexName: index.name
        }
      }),
      onClick: index => onDelete(index.name),
      type: 'icon'
    }],
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.actions.columnTitle', {
      defaultMessage: 'Actions'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: indices,
    columns: columns,
    onChange: onChange,
    pagination: {
      pageIndex: meta.page.from / (meta.page.size || 1),
      pageSize: meta.page.size,
      showPerPageOptions: false,
      totalItemCount: meta.page.total
    },
    tableLayout: "fixed",
    loading: isLoading
  });
};
exports.IndicesTable = IndicesTable;