"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncJobsViewLogic = void 0;
var _kea = require("kea");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _searchConnectors = require("@kbn/search-connectors");
var _api = require("../../../../../../common/types/api");
var _cancel_sync_api_logic = require("../../../api/connector/cancel_sync_api_logic");
var _fetch_sync_jobs_api_logic = require("../../../api/connector/fetch_sync_jobs_api_logic");
var _cancel_syncs_logic = require("../connector/cancel_syncs_logic");
var _index_view_logic = require("../index_view_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UI_REFRESH_INTERVAL = 2000;
const SyncJobsViewLogic = exports.SyncJobsViewLogic = (0, _kea.kea)({
  actions: {
    refetchSyncJobs: true,
    setCancelSyncJob: syncJobId => ({
      syncJobId: syncJobId !== null && syncJobId !== void 0 ? syncJobId : null
    }),
    setSelectedSyncJobCategory: category => ({
      category
    })
  },
  connect: {
    actions: [_fetch_sync_jobs_api_logic.FetchSyncJobsApiLogic, ['apiError as fetchSyncJobsError', 'apiReset as resetFetchSyncJobsIndexApi', 'apiSuccess as fetchSyncJobsApiSuccess', 'makeRequest as fetchSyncJobs'], _cancel_sync_api_logic.CancelSyncApiLogic, ['apiError as cancelSyncError', 'apiReset as resetCancelSyncJobApi', 'apiSuccess as cancelSyncSuccess', 'makeRequest as cancelSyncJob'], _cancel_syncs_logic.CancelSyncsLogic, ['cancelSyncsApiError', 'cancelSyncsApiSuccess', 'cancelSyncs'], _index_view_logic.IndexViewLogic, ['startSync', 'startIncrementalSync', 'startAccessControlSync']],
    values: [_index_view_logic.IndexViewLogic, ['connectorId'], _fetch_sync_jobs_api_logic.FetchSyncJobsApiLogic, ['data as syncJobsData', 'status as syncJobsStatus'], _cancel_sync_api_logic.CancelSyncApiLogic, ['status as cancelSyncJobStatus']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    cancelSyncError: async (_, breakpoint) => {
      actions.resetCancelSyncJobApi();
      await breakpoint(UI_REFRESH_INTERVAL);
      if (values.connectorId) {
        actions.refetchSyncJobs();
      }
    },
    cancelSyncSuccess: async (_, breakpoint) => {
      actions.resetCancelSyncJobApi();
      await breakpoint(UI_REFRESH_INTERVAL);
      if (values.connectorId) {
        actions.refetchSyncJobs();
      }
    },
    cancelSyncsApiError: async (_, breakpoint) => {
      await breakpoint(UI_REFRESH_INTERVAL);
      if (values.connectorId) {
        actions.refetchSyncJobs();
      }
    },
    cancelSyncsApiSuccess: async (_, breakpoint) => {
      await breakpoint(UI_REFRESH_INTERVAL);
      if (values.connectorId) {
        actions.refetchSyncJobs();
      }
    },
    refetchSyncJobs: () => {
      if (values.connectorId) {
        var _values$syncJobsPagin;
        actions.fetchSyncJobs({
          connectorId: values.connectorId,
          from: values.syncJobsPagination.pageIndex * (values.syncJobsPagination.pageSize || 0),
          size: (_values$syncJobsPagin = values.syncJobsPagination.pageSize) !== null && _values$syncJobsPagin !== void 0 ? _values$syncJobsPagin : 10,
          type: values.selectedSyncJobCategory
        });
      }
    },
    startAccessControlSync: async (_, breakpoint) => {
      await breakpoint(UI_REFRESH_INTERVAL);
      if (values.connectorId) {
        actions.refetchSyncJobs();
      }
    },
    startIncrementalSync: async (_, breakpoint) => {
      await breakpoint(UI_REFRESH_INTERVAL);
      if (values.connectorId) {
        actions.refetchSyncJobs();
      }
    },
    startSync: async (_, breakpoint) => {
      await breakpoint(UI_REFRESH_INTERVAL);
      if (values.connectorId) {
        actions.refetchSyncJobs();
      }
    }
  }),
  path: ['enterprise_search', 'content', 'sync_jobs_view_logic'],
  reducers: {
    selectedSyncJobCategory: ['content', {
      setSelectedSyncJobCategory: (_, {
        category
      }) => category
    }],
    syncJobToCancel: [null, {
      resetCancelSyncJobApi: () => null,
      setCancelSyncJob: (_, {
        syncJobId
      }) => syncJobId !== null && syncJobId !== void 0 ? syncJobId : null
    }],
    syncJobs: [[], {
      fetchSyncJobsApiSuccess: (currentState, {
        data
      }) => {
        var _data$map;
        const newState = (_data$map = data === null || data === void 0 ? void 0 : data.map(syncJob => {
          return {
            ...syncJob,
            duration: syncJob.started_at ? _moment.default.duration((0, _moment.default)(syncJob.completed_at || new Date()).diff((0, _moment.default)(syncJob.started_at))) : undefined,
            lastSync: syncJob.completed_at
          };
        })) !== null && _data$map !== void 0 ? _data$map : [];
        return (0, _lodash.isEqual)(currentState, newState) ? currentState : newState;
      }
    }],
    syncTriggeredLocally: [false, {
      cancelSyncError: () => true,
      cancelSyncJob: () => true,
      cancelSyncs: () => true,
      fetchSyncJobsApiSuccess: () => false,
      startAccessControlSync: () => true,
      startIncrementalSync: () => true,
      startSync: () => true
    }]
  },
  selectors: ({
    selectors
  }) => ({
    cancelSyncJobLoading: [() => [selectors.cancelSyncJobStatus], status => status === _api.Status.LOADING],
    syncJobsLoading: [() => [selectors.syncJobsStatus], status => status === _api.Status.IDLE || status === _api.Status.LOADING],
    syncJobsPagination: [() => [selectors.syncJobsData], data => data ? (0, _searchConnectors.pageToPagination)(data._meta.page) : {
      pageIndex: 0,
      pageSize: 10,
      totalItemCount: 0
    }]
  })
});