"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncJobs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _kibana = require("../../../../shared/kibana");
var _index_view_logic = require("../index_view_logic");
var _sync_jobs_view_logic = require("./sync_jobs_view_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SyncJobs = ({
  errorOnAccessSync = false,
  errorOnContentSync = false
}) => {
  const {
    hasDocumentLevelSecurityFeature
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    productFeatures
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const shouldShowAccessSyncs = productFeatures.hasDocumentLevelSecurityEnabled && hasDocumentLevelSecurityFeature;
  const {
    connectorId,
    syncJobsPagination: pagination,
    syncJobs,
    cancelSyncJobLoading,
    syncJobToCancel,
    selectedSyncJobCategory,
    syncTriggeredLocally
  } = (0, _kea.useValues)(_sync_jobs_view_logic.SyncJobsViewLogic);
  const {
    fetchSyncJobs,
    cancelSyncJob,
    setCancelSyncJob,
    setSelectedSyncJobCategory
  } = (0, _kea.useActions)(_sync_jobs_view_logic.SyncJobsViewLogic);
  (0, _react.useEffect)(() => {
    if (connectorId) {
      var _pagination$pageSize;
      fetchSyncJobs({
        connectorId,
        from: pagination.pageIndex * (pagination.pageSize || 0),
        size: (_pagination$pageSize = pagination.pageSize) !== null && _pagination$pageSize !== void 0 ? _pagination$pageSize : 10,
        type: selectedSyncJobCategory
      });
    }
  }, [connectorId, selectedSyncJobCategory]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, shouldShowAccessSyncs && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.enterpriseSearch.content.syncJobs.lastSync.tableSelector.legend', {
      defaultMessage: 'Select sync job type to display.'
    }),
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.syncJobs.lastSync.tableSelector.name', {
      defaultMessage: 'Sync job type'
    }),
    idSelected: selectedSyncJobCategory,
    onChange: optionId => {
      if (optionId === 'content' || optionId === 'access_control') {
        setSelectedSyncJobCategory(optionId);
      }
    },
    options: [{
      id: 'content',
      label: _i18n.i18n.translate('xpack.enterpriseSearch.content.syncJobs.lastSync.tableSelector.content.label', {
        defaultMessage: 'Content syncs'
      }),
      ...(errorOnContentSync ? {
        iconSide: 'right',
        iconType: 'warning'
      } : {})
    }, {
      id: 'access_control',
      label: _i18n.i18n.translate('xpack.enterpriseSearch.content.syncJobs.lastSync.tableSelector.accessControl.label', {
        defaultMessage: 'Access control syncs'
      }),
      ...(errorOnAccessSync ? {
        iconSide: 'right',
        iconType: 'warning'
      } : {})
    }]
  }), selectedSyncJobCategory === 'content' ? /*#__PURE__*/_react.default.createElement(_searchConnectors.SyncJobsTable, {
    isLoading: syncTriggeredLocally,
    onPaginate: ({
      page: {
        index,
        size
      }
    }) => {
      if (connectorId) {
        fetchSyncJobs({
          connectorId,
          from: index * size,
          size,
          type: selectedSyncJobCategory
        });
      }
    },
    pagination: pagination,
    syncJobs: syncJobs,
    type: "content",
    cancelConfirmModalProps: {
      isLoading: cancelSyncJobLoading,
      onConfirmCb: syncJobId => {
        cancelSyncJob({
          syncJobId
        });
      },
      setSyncJobIdToCancel: setCancelSyncJob,
      syncJobIdToCancel: syncJobToCancel !== null && syncJobToCancel !== void 0 ? syncJobToCancel : undefined
    }
  }) : /*#__PURE__*/_react.default.createElement(_searchConnectors.SyncJobsTable, {
    isLoading: syncTriggeredLocally,
    onPaginate: ({
      page: {
        index,
        size
      }
    }) => {
      if (connectorId) {
        fetchSyncJobs({
          connectorId,
          from: index * size,
          size,
          type: 'access_control'
        });
      }
    },
    cancelConfirmModalProps: {
      isLoading: cancelSyncJobLoading,
      onConfirmCb: syncJobId => {
        cancelSyncJob({
          syncJobId
        });
      },
      setSyncJobIdToCancel: setCancelSyncJob,
      syncJobIdToCancel: syncJobToCancel !== null && syncJobToCancel !== void 0 ? syncJobToCancel : undefined
    },
    pagination: pagination,
    syncJobs: syncJobs,
    type: "access_control"
  }));
};
exports.SyncJobs = SyncJobs;