"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModelDeploymentInProgress = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _text_expansion_callout = require("./text_expansion_callout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ModelDeploymentInProgress = ({
  dismiss,
  isDismissable
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  color: "success"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "row",
  gutterSize: "s",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  color: "success",
  type: "clock"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "success",
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.deployingTitle', {
  defaultMessage: 'Your ELSER model is deploying.'
})))), isDismissable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_text_expansion_callout.TextExpansionDismissButton, {
  dismiss: dismiss
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.deployingBody', {
  defaultMessage: 'You can continue creating your pipeline with other uploaded models in the meantime.'
}))))));
exports.ModelDeploymentInProgress = ModelDeploymentInProgress;