"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentFieldsPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _field_rules_table = require("./field_rules_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ContentFieldsPanel = ({
  contentFields,
  editNewField,
  editExistingField,
  removeField
}) => {
  return contentFields.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.fieldRules.emptyMessageTitle', {
      defaultMessage: 'This extraction rule has no content fields'
    })),
    titleSize: "s",
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.fieldRules.emptyMessageDescription', {
      defaultMessage: 'Create a content field to pinpoint which parts of a webpage to pull data from.'
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-addContentFirstContentField",
      iconType: "plusInCircle",
      onClick: editNewField
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.fieldRules.emptyMessageAddRuleLabel', {
      defaultMessage: 'Add content fields'
    }))
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.fieldRules.contentFieldDescription', {
    defaultMessage: 'Create a content field to pinpoint which parts of a webpage to pull data from.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-addContentFieldRule",
    iconType: "plusInCircle",
    onClick: editNewField
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.fieldRules.addContentFieldRuleLabel', {
    defaultMessage: 'Add content field rule'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_field_rules_table.FieldRulesTable, {
    editRule: editExistingField,
    fieldRules: contentFields,
    removeRule: removeField
  }));
};
exports.ContentFieldsPanel = ContentFieldsPanel;