"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthenticationPanelDeleteConfirmationModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../shared/constants");
var _authentication_panel_logic = require("./authentication_panel_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AuthenticationPanelDeleteConfirmationModal = () => {
  const {
    deleteCredentials,
    setIsModalVisible
  } = (0, _kea.useActions)(_authentication_panel_logic.AuthenticationPanelLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.authenticationPanel.deleteConfirmationModal.title', {
      defaultMessage: 'Are you sure you want to delete these settings?'
    }),
    onCancel: event => {
      event === null || event === void 0 ? void 0 : event.preventDefault();
      setIsModalVisible(false);
    },
    onConfirm: event => {
      event.preventDefault();
      deleteCredentials();
    },
    cancelButtonText: _constants.CANCEL_BUTTON_LABEL,
    confirmButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.authenticationPanel.deleteConfirmationModal.deleteButtonLabel', {
      defaultMessage: 'Delete'
    }),
    defaultFocusedButton: "confirm",
    buttonColor: "danger"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.authenticationPanel.deleteConfirmationModal.description', {
    defaultMessage: 'Deleting these settings might prevent the crawler from indexing protected areas of the domain. This can not be undone.'
  }));
};
exports.AuthenticationPanelDeleteConfirmationModal = AuthenticationPanelDeleteConfirmationModal;