"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NativeConnectorConfigurationConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchConnectors = require("@kbn/search-connectors");
var _connector_configuration = require("@kbn/search-connectors/components/configuration/connector_configuration");
var _api = require("../../../../../../../common/types/api");
var _doc_links = require("../../../../../shared/doc_links");
var _http = require("../../../../../shared/http");
var _licensing = require("../../../../../shared/licensing");
var _update_connector_configuration_api_logic = require("../../../../api/connector/update_connector_configuration_api_logic");
var _sync_rules_helpers = require("../../../../utils/sync_rules_helpers");
var _connector_view_logic = require("../../../connector_detail/connector_view_logic");
var _connector_filtering_logic = require("../sync_rules/connector_filtering_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NativeConnectorConfigurationConfig = ({
  connector,
  nativeConnector,
  status
}) => {
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const {
    status: updateStatus
  } = (0, _kea.useValues)(_update_connector_configuration_api_logic.ConnectorConfigurationApiLogic);
  const {
    makeRequest
  } = (0, _kea.useActions)(_update_connector_configuration_api_logic.ConnectorConfigurationApiLogic);
  const {
    hasAdvancedFilteringFeature
  } = (0, _kea.useValues)(_connector_view_logic.ConnectorViewLogic);
  const {
    advancedSnippet
  } = (0, _kea.useValues)(_connector_filtering_logic.ConnectorFilteringLogic);
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const isAdvancedSnippetEmpty = (0, _sync_rules_helpers.isAdvancedSyncRuleSnippetEmpty)(advancedSnippet);
  return /*#__PURE__*/_react.default.createElement(_connector_configuration.ConnectorConfigurationComponent, {
    connector: connector,
    hasPlatinumLicense: hasPlatinumLicense,
    isLoading: updateStatus === _api.Status.LOADING,
    saveConfig: configuration => makeRequest({
      configuration,
      connectorId: connector.id
    }),
    subscriptionLink: _doc_links.docLinks.licenseManagement,
    stackManagementLink: http.basePath.prepend('/app/management/stack/license_management')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.config.encryptionWarningMessage', {
    defaultMessage: 'Encryption for data source credentials is unavailable in this version. Your data source credentials will be stored, unencrypted, in Elasticsearch.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "entSearchContent-connector-nativeConnector-learnMoreAboutSecurityLink",
    "data-telemetry-id": "entSearchContent-connector-nativeConnector-learnMoreAboutSecurityLink",
    href: _doc_links.docLinks.elasticsearchSecureCluster,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.config.securityDocumentationLinkLabel', {
    defaultMessage: 'Learn more about Elasticsearch security'
  }))), nativeConnector.externalAuthDocsUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "entSearchContent-connector-nativeConnector-configNameAuthenticationLink",
    "data-telemetry-id": "entSearchContent-connector-nativeConnector-configNameAuthenticationLink",
    href: nativeConnector.externalAuthDocsUrl,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.config.sourceSecurityDocumentationLinkLabel', {
    defaultMessage: '{name} authentication',
    values: {
      name: nativeConnector.name
    }
  })))), status === _searchConnectors.ConnectorStatus.CONNECTED && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "check",
    color: "success",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.connectorConnected', {
      defaultMessage: 'Your connector {name} has connected to Search successfully.',
      values: {
        name: nativeConnector.name
      }
    })
  })), connector.status && hasAdvancedFilteringFeature && !isAdvancedSnippetEmpty && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.connectorPackage.advancedRulesCallout', {
      defaultMessage: 'Configuration warning'
    }),
    iconType: "iInCircle",
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.connector_detail.configurationConnector.connectorPackage.advancedRulesCallout.description",
    defaultMessage: "{advancedSyncRulesDocs} can override some configuration fields.",
    values: {
      advancedSyncRulesDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "entSearchContent-connector-nativeConnector-advancedSyncRulesDocsLink",
        "data-telemetry-id": "entSearchContent-connector-nativeConnector-advancedSyncRulesDocsLink",
        href: _doc_links.docLinks.syncRules,
        target: "_blank"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.connectorPackage.advancedSyncRulesDocs', {
        defaultMessage: 'Advanced Sync Rules'
      }))
    }
  }))));
};
exports.NativeConnectorConfigurationConfig = NativeConnectorConfigurationConfig;