"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CancelSyncsLogic = void 0;
var _kea = require("kea");
var _cancel_syncs_api_logic = require("../../../api/connector/cancel_syncs_api_logic");
var _index_view_logic = require("../index_view_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CancelSyncsLogic = exports.CancelSyncsLogic = (0, _kea.kea)({
  actions: {
    cancelSyncs: true
  },
  connect: {
    actions: [_cancel_syncs_api_logic.CancelSyncsApiLogic, ['apiError as cancelSyncsApiError', 'apiSuccess as cancelSyncsApiSuccess', 'makeRequest as makeCancelSyncsRequest']],
    values: [_index_view_logic.IndexViewLogic, ['connectorId', 'isConnectorIndex']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    cancelSyncs: () => {
      if (values.isConnectorIndex && values.connectorId) {
        actions.makeCancelSyncsRequest({
          connectorId: values.connectorId
        });
      }
    }
  })
});