"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewConnectorLogic = void 0;
var _kea = require("kea");
var _add_connector_api_logic = require("../../../api/connector/add_connector_api_logic");
var _index_exists_api_logic = require("../../../api/index/index_exists_api_logic");
var _validate_index_name = require("../../../utils/validate_index_name");
var _constants = require("../constants");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NewConnectorLogic = exports.NewConnectorLogic = (0, _kea.kea)({
  actions: {
    setLanguageSelectValue: language => ({
      language
    }),
    setRawName: rawName => ({
      rawName
    })
  },
  connect: {
    actions: [_add_connector_api_logic.AddConnectorApiLogic, ['apiSuccess as connectorCreated'], _index_exists_api_logic.IndexExistsApiLogic, ['makeRequest']],
    values: [_index_exists_api_logic.IndexExistsApiLogic, ['data']]
  },
  path: ['enterprise_search', 'content', 'new_search_index'],
  reducers: {
    languageSelectValue: [_constants.UNIVERSAL_LANGUAGE_VALUE, {
      setLanguageSelectValue: (_, {
        language
      }) => language !== null && language !== void 0 ? language : null
    }],
    rawName: ['', {
      setRawName: (_, {
        rawName
      }) => rawName
    }]
  },
  selectors: ({
    selectors
  }) => ({
    fullIndexName: [() => [selectors.rawName], name => name],
    fullIndexNameExists: [() => [selectors.data, selectors.fullIndexName], (data, fullIndexName) => (data === null || data === void 0 ? void 0 : data.exists) === true && data.indexName === fullIndexName],
    fullIndexNameIsValid: [() => [selectors.fullIndexName], fullIndexName => (0, _validate_index_name.isValidIndexName)(fullIndexName)],
    language: [() => [selectors.languageSelectValue], languageSelectValue => (0, _utils.getLanguageForOptimization)(languageSelectValue)]
  })
});