"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NativePopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NativePopover = ({
  button,
  isPopoverOpen,
  closePopover
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    onClick: e => {
      e.stopPropagation();
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.selectConnectore.nativePopover.title', {
    defaultMessage: 'Elastic Cloud'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    size: "s",
    css: (0, _react2.css)`
          max-width: calc(${euiTheme.size.xl} * 10);
        `
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.selectConnectore.nativePopover.description', {
    defaultMessage: 'Native connectors are hosted on Elastic Cloud. Get started with a free 14-day trial.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "entSearchContent-connectors-nativePopover-trialButton",
    "data-telemetry-id": "entSearchContent-connectors-nativePopover-trialButton",
    iconType: "popout",
    target: "_blank",
    href: "https://www.elastic.co/cloud/cloud-trial-overview"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.selectConnector.cloudTrialButton', {
    defaultMessage: 'Elastic Cloud Trial'
  }))))));
};
exports.NativePopover = NativePopover;