"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttachIndexBox = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _api = require("../../../../../common/types/api");
var _fetch_available_indices_api_logic = require("../../api/index/fetch_available_indices_api_logic");
var _format_api_name = require("../../utils/format_api_name");
var _attach_index_logic = require("./attach_index_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CREATE_NEW_INDEX_GROUP_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.attachIndexBox.optionsGroup.createNewIndex', {
  defaultMessage: 'Create new index'
});
const SELECT_EXISTING_INDEX_GROUP_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.attachIndexBox.optionsGroup.selectExistingIndex', {
  defaultMessage: 'Select existing index'
});
const AttachIndexBox = ({
  connector
}) => {
  var _data$indexNames$map, _data$indexNames$some, _data$indexNames$some2, _attachApiError$body, _createApiError$body;
  const {
    indexName
  } = (0, _reactRouterDom.useParams)();
  const {
    createIndex,
    attachIndex,
    setConnector,
    checkIndexExists
  } = (0, _kea.useActions)(_attach_index_logic.AttachIndexLogic);
  const {
    isLoading: isSaveLoading,
    isExistLoading,
    indexExists,
    createApiError,
    attachApiError
  } = (0, _kea.useValues)(_attach_index_logic.AttachIndexLogic);
  const [selectedIndex, setSelectedIndex] = (0, _react.useState)(connector.index_name ? {
    label: connector.index_name
  } : undefined);
  const [selectedLanguage] = (0, _react.useState)();
  const [query, setQuery] = (0, _react.useState)();
  const [sanitizedName, setSanitizedName] = (0, _react.useState)((0, _format_api_name.formatApiName)(connector.name));
  const {
    makeRequest
  } = (0, _kea.useActions)(_fetch_available_indices_api_logic.FetchAvailableIndicesAPILogic);
  const {
    data,
    status
  } = (0, _kea.useValues)(_fetch_available_indices_api_logic.FetchAvailableIndicesAPILogic);
  const isLoading = [_api.Status.IDLE, _api.Status.LOADING].includes(status);
  const onSave = () => {
    if (selectedIndex !== null && selectedIndex !== void 0 && selectedIndex.shouldCreate) {
      createIndex({
        indexName: selectedIndex.label,
        language: selectedLanguage !== null && selectedLanguage !== void 0 ? selectedLanguage : null
      });
    } else if (selectedIndex && !(selectedIndex.label === connector.index_name)) {
      attachIndex({
        connectorId: connector.id,
        indexName: selectedIndex.label
      });
    }
  };
  const options = isLoading ? [] : (_data$indexNames$map = data === null || data === void 0 ? void 0 : data.indexNames.map(name => {
    return {
      label: name
    };
  })) !== null && _data$indexNames$map !== void 0 ? _data$indexNames$map : [];
  const hasMatchingOptions = (_data$indexNames$some = data === null || data === void 0 ? void 0 : data.indexNames.some(name => {
    var _query$searchValue$to;
    return name.toLocaleLowerCase().includes((_query$searchValue$to = query === null || query === void 0 ? void 0 : query.searchValue.toLocaleLowerCase()) !== null && _query$searchValue$to !== void 0 ? _query$searchValue$to : '');
  })) !== null && _data$indexNames$some !== void 0 ? _data$indexNames$some : false;
  const isFullMatch = (_data$indexNames$some2 = data === null || data === void 0 ? void 0 : data.indexNames.some(name => name.toLocaleLowerCase() === (query === null || query === void 0 ? void 0 : query.searchValue.toLocaleLowerCase()))) !== null && _data$indexNames$some2 !== void 0 ? _data$indexNames$some2 : false;
  const shouldPrependUserInputAsOption = !!(query !== null && query !== void 0 && query.searchValue) && hasMatchingOptions && !isFullMatch;
  const groupedOptions = shouldPrependUserInputAsOption ? [...[{
    label: CREATE_NEW_INDEX_GROUP_LABEL,
    options: [{
      label: query.searchValue
    }]
  }], ...[{
    label: SELECT_EXISTING_INDEX_GROUP_LABEL,
    options
  }]] : [{
    label: SELECT_EXISTING_INDEX_GROUP_LABEL,
    options
  }];
  (0, _react.useEffect)(() => {
    setConnector(connector);
    makeRequest({});
    if (!connector.index_name && connector.name && sanitizedName) {
      checkIndexExists({
        indexName: sanitizedName
      });
    }
  }, [connector.id]);
  (0, _react.useEffect)(() => {
    makeRequest({
      searchQuery: (query === null || query === void 0 ? void 0 : query.searchValue) || undefined
    });
    if (query !== null && query !== void 0 && query.searchValue) {
      checkIndexExists({
        indexName: query.searchValue
      });
    }
  }, [query]);
  (0, _react.useEffect)(() => {
    setSanitizedName((0, _format_api_name.formatApiName)(connector.name));
  }, [connector.name]);
  const {
    hash
  } = (0, _reactRouterDom.useLocation)();
  (0, _react.useEffect)(() => {
    if (hash) {
      const id = hash.replace('#', '');
      if (id === 'attachIndexBox') {
        const element = document.getElementById(id);
        if (element) {
          element.scrollIntoView({
            behavior: 'smooth'
          });
        }
      }
    }
  }, [hash]);
  const error = !!query && indexExists[query.searchValue] ? _i18n.i18n.translate('xpack.enterpriseSearch.attachIndexBox.euiFormRow.associatedIndexErrorTextLabel', {
    defaultMessage: "You can't create a new index using an existing index name. Choose an existing index or create a new index with a new name."
  }) : (attachApiError === null || attachApiError === void 0 ? void 0 : (_attachApiError$body = attachApiError.body) === null || _attachApiError$body === void 0 ? void 0 : _attachApiError$body.message) || (createApiError === null || createApiError === void 0 ? void 0 : (_createApiError$body = createApiError.body) === null || _createApiError$body === void 0 ? void 0 : _createApiError$body.message) || undefined;
  if (indexName) {
    // We don't want to let people edit indices when on the index route
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    id: "attachIndexBox"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.attachIndexBox.h4.attachAnIndexLabel', {
    defaultMessage: 'Attach an index'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.attachIndexBox.thisIndexWillHoldTextLabel",
    defaultMessage: "This index will hold your data source content, and is optimized with default field mappings for relevant search experiences. Give your index a unique name and optionally set a default language analyzer for the index."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.attachIndexBox.euiFormRow.associatedIndexLabel', {
      defaultMessage: 'Associated index'
    }),
    helpText: _i18n.i18n.translate('xpack.enterpriseSearch.attachIndexBox.euiFormRow.associatedIndexHelpTextLabel', {
      defaultMessage: 'You can use an existing index or create a new one.'
    }),
    error: error,
    isInvalid: !!error
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.attachIndexBox.euiFormRow.indexSelector.placeholder', {
      defaultMessage: 'Select or create an index'
    }),
    customOptionText: _i18n.i18n.translate('xpack.enterpriseSearch.attachIndexBox.euiFormRow.indexSelector.customOption', {
      defaultMessage: 'Create index {searchValue}',
      values: {
        searchValue: '{searchValue}'
      }
    }),
    isLoading: isLoading,
    options: groupedOptions,
    onSearchChange: searchValue => {
      setQuery({
        isFullMatch: options.some(option => option.label === searchValue),
        searchValue
      });
    },
    onChange: selection => {
      var _selection$;
      const currentSelection = (_selection$ = selection[0]) !== null && _selection$ !== void 0 ? _selection$ : undefined;
      const selectedIndexOption = currentSelection ? {
        label: currentSelection.label,
        shouldCreate: shouldPrependUserInputAsOption && !!((currentSelection === null || currentSelection === void 0 ? void 0 : currentSelection.label) === (query === null || query === void 0 ? void 0 : query.searchValue))
      } : undefined;
      setSelectedIndex(selectedIndexOption);
    },
    selectedOptions: selectedIndex ? [selectedIndex] : undefined,
    onCreateOption: value => {
      setSelectedIndex({
        label: value.trim(),
        shouldCreate: true
      });
    },
    singleSelection: true
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "entSearchContent-connector-connectorDetail-saveConfigurationButton",
    "data-telemetry-id": "entSearchContent-connector-connectorDetail-saveConfigurationButton",
    onClick: () => onSave(),
    disabled: !selectedIndex || selectedIndex.label === connector.index_name,
    isLoading: isSaveLoading
  }, _i18n.i18n.translate('xpack.enterpriseSearch.attachIndexBox.saveConfigurationButtonLabel', {
    defaultMessage: 'Save configuration'
  })))), !connector.index_name && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    size: "full"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.attachIndexBox.orPanelLabel', {
    defaultMessage: 'OR'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    size: "full"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-connector-connectorDetail-createAttachIndexButton",
    "data-test-subj": "entSearchContent-connector-connectorDetail-createAttachIndexButton",
    iconType: "sparkles",
    color: "primary",
    fill: true,
    onClick: () => {
      createIndex({
        indexName: sanitizedName,
        language: null
      });
      setSelectedIndex({
        label: sanitizedName
      });
    },
    isLoading: isSaveLoading || isExistLoading,
    disabled: indexExists[sanitizedName]
  }, _i18n.i18n.translate('xpack.enterpriseSearch.attachIndexBox.createSameIndexButtonLabel', {
    defaultMessage: 'Create and attach an index named {indexName}',
    values: {
      indexName: sanitizedName
    }
  })), indexExists[sanitizedName] ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.attachIndexBox.indexNameExistsError', {
    defaultMessage: 'Index with name {indexName} already exists',
    values: {
      indexName: sanitizedName
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)))));
};
exports.AttachIndexBox = AttachIndexBox;