"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchIndices = exports.FetchIndicesAPILogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchIndices = async ({
  from,
  onlyShowSearchOptimizedIndices,
  returnHiddenIndices,
  searchQuery,
  size
}) => {
  const {
    http
  } = _http.HttpLogic.values;
  const route = '/internal/enterprise_search/indices';
  const query = {
    from,
    only_show_search_optimized_indices: onlyShowSearchOptimizedIndices,
    return_hidden_indices: returnHiddenIndices,
    search_query: searchQuery || null,
    size: size !== null && size !== void 0 ? size : 20
  };
  const response = await http.get(route, {
    query
  });

  // We need this to determine whether to show the empty state on the indices page
  const isInitialRequest = from === 0 && !searchQuery && !onlyShowSearchOptimizedIndices;
  return {
    ...response,
    isInitialRequest,
    onlyShowSearchOptimizedIndices,
    returnHiddenIndices,
    searchQuery
  };
};
exports.fetchIndices = fetchIndices;
const FetchIndicesAPILogic = exports.FetchIndicesAPILogic = (0, _create_api_logic.createApiLogic)(['content', 'indices_api_logic'], fetchIndices);