"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.attachIndex = exports.AttachIndexApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const attachIndex = async ({
  connectorId,
  indexName
}) => {
  const route = `/internal/enterprise_search/connectors/${connectorId}/index_name/${indexName}`;
  await _http.HttpLogic.values.http.put(route);
  return {
    connectorId,
    indexName
  };
};
exports.attachIndex = attachIndex;
const AttachIndexApiLogic = exports.AttachIndexApiLogic = (0, _create_api_logic.createApiLogic)(['add_connector_api_logic'], attachIndex);