"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Schema = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _schema = require("../../../../shared/schema");
var _app_logic = require("../../../app_logic");
var _engine = require("../../engine");
var _layout = require("../../layout");
var _components = require("../components");
var _constants = require("../constants");
var _schema_logic = require("../schema_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Schema = () => {
  const {
    myRole: {
      canManageEngines
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    loadSchema,
    updateSchema,
    addSchemaField,
    openModal,
    closeModal
  } = (0, _kea.useActions)(_schema_logic.SchemaLogic);
  const {
    dataLoading,
    isUpdating,
    hasSchema,
    hasSchemaChanged,
    isModalOpen
  } = (0, _kea.useValues)(_schema_logic.SchemaLogic);
  const {
    isElasticsearchEngine
  } = (0, _kea.useValues)(_engine.EngineLogic);
  (0, _react.useEffect)(() => {
    loadSchema();
  }, []);
  const schemaActions = [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    disabled: !hasSchemaChanged,
    isLoading: isUpdating,
    onClick: () => updateSchema(),
    "data-test-subj": "updateSchemaButton"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.updateSchemaButtonLabel', {
    defaultMessage: 'Save changes'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    iconType: "plusInCircle",
    disabled: isUpdating,
    onClick: openModal,
    "data-test-subj": "addSchemaFieldModalButton"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.createSchemaFieldButtonLabel', {
    defaultMessage: 'Create a schema field'
  }))];
  const editableSchemaHeader = {
    pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.pageTitle', {
      defaultMessage: 'Manage engine schema'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.pageDescription', {
      defaultMessage: 'Add new fields or change the types of existing ones.'
    }),
    rightSideItems: canManageEngines ? schemaActions : []
  };
  const readOnlySchemaHeader = {
    pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.readOnly.pageTitle', {
      defaultMessage: 'Engine schema'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.readOnly.pageDescription', {
      defaultMessage: 'View schema field types.'
    })
  };
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _engine.getEngineBreadcrumbs)([_constants.SCHEMA_TITLE]),
    pageHeader: isElasticsearchEngine ? readOnlySchemaHeader : editableSchemaHeader,
    isLoading: dataLoading,
    isEmptyState: !hasSchema,
    emptyState: /*#__PURE__*/_react.default.createElement(_components.EmptyState, null)
  }, /*#__PURE__*/_react.default.createElement(_components.SchemaCallouts, null), /*#__PURE__*/_react.default.createElement(_components.SchemaTable, null), isModalOpen && /*#__PURE__*/_react.default.createElement(_schema.SchemaAddFieldModal, {
    addNewField: addSchemaField,
    closeAddFieldModal: closeModal
  }));
};
exports.Schema = Schema;