"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyState = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _schema = require("../../../../shared/schema");
var _routes = require("../../../routes");
var _schema_logic = require("../schema_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyState = () => {
  const {
    isModalOpen
  } = (0, _kea.useValues)(_schema_logic.SchemaLogic);
  const {
    addSchemaField,
    closeModal
  } = (0, _kea.useActions)(_schema_logic.SchemaLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "database",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.empty.title', {
      defaultMessage: 'Create a schema'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.empty.description', {
      defaultMessage: 'Create schema fields in advance, or index some documents and a schema will be created for you.'
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      target: "_blank",
      iconType: "popout",
      href: _routes.INDEXING_SCHEMA_DOCS_URL
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.empty.buttonLabel', {
      defaultMessage: 'Read the indexing schema guide'
    }))
  }), isModalOpen && /*#__PURE__*/_react.default.createElement(_schema.SchemaAddFieldModal, {
    addNewField: addSchemaField,
    closeAddFieldModal: closeModal
  }));
};
exports.EmptyState = EmptyState;