"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestionsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../shared/constants");
var _icons = require("../../../../shared/icons");
var _kibana = require("../../../../shared/kibana");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _table_pagination = require("../../../../shared/table_pagination");
var _routes = require("../../../routes");
var _formatted_date_time = require("../../../utils/formatted_date_time");
var _data_panel = require("../../data_panel");
var _engine = require("../../engine");
var _utils = require("../utils");
var _suggestions_logic = require("./suggestions_logic");
require("./suggestions_table.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSuggestionRoute = query => {
  return (0, _engine.generateEnginePath)(_routes.ENGINE_CURATION_SUGGESTION_PATH, {
    query
  });
};
const columns = [{
  field: 'query',
  name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestionsTable.column.queryTableHeader', {
    defaultMessage: 'Query'
  }),
  render: (query, curation) => /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    to: getSuggestionRoute(query)
  }, query, curation.override_manual_curation && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "warning",
    color: "warning",
    className: "suggestionsTableBadge"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestionsTable.overridesLabel', {
    defaultMessage: 'Overrides'
  }))))
}, {
  field: 'updated_at',
  dataType: 'string',
  name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestionsTable.column.lastUpdatedTableHeader', {
    defaultMessage: 'Last updated'
  }),
  render: dateString => /*#__PURE__*/_react.default.createElement(_formatted_date_time.FormattedDateTime, {
    date: (0, _utils.convertToDate)(dateString)
  })
}, {
  field: 'promoted',
  name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestionsTable.column.promotedDocumentsTableHeader', {
    defaultMessage: 'Promoted results'
  }),
  render: promoted => /*#__PURE__*/_react.default.createElement("span", null, promoted.length)
}, {
  actions: [{
    name: _constants.VIEW_BUTTON_LABEL,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestionsTable.viewTooltip', {
      defaultMessage: 'View suggestion'
    }),
    type: 'icon',
    icon: 'eye',
    onClick: item => {
      const {
        navigateToUrl
      } = _kibana.KibanaLogic.values;
      const query = item.query;
      navigateToUrl(getSuggestionRoute(query));
    }
  }],
  width: '120px'
}];
const SuggestionsTable = () => {
  const {
    loadSuggestions,
    onPaginate
  } = (0, _kea.useActions)(_suggestions_logic.SuggestionsLogic);
  const {
    meta,
    suggestions,
    dataLoading
  } = (0, _kea.useValues)(_suggestions_logic.SuggestionsLogic);
  (0, _react.useEffect)(() => {
    loadSuggestions();
  }, [meta.page.current]);
  const totalSuggestions = meta.page.total_results;
  return /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    className: "suggestionsTable",
    iconType: _icons.LightbulbIcon,
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestionsTable.title', {
      defaultMessage: '{totalSuggestions} Suggestions',
      values: {
        totalSuggestions
      }
    })),
    subtitle: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.suggestionsTable.description', {
      defaultMessage: 'Based on your analytics, results for the following queries could be improved by promoting some documents.'
    }),
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: suggestions,
    responsive: true,
    hasActions: true,
    loading: dataLoading,
    pagination: {
      ...(0, _table_pagination.convertMetaToPagination)(meta),
      showPerPageOptions: false
    },
    onChange: (0, _table_pagination.handlePageChange)(onPaginate)
  }));
};
exports.SuggestionsTable = SuggestionsTable;