"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startTrackingEmbeddableUnsavedChanges = void 0;
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getDefaultDiffingApi = () => {
  return {
    unsavedChanges: new _rxjs.BehaviorSubject(undefined),
    resetUnsavedChanges: () => {},
    cleanup: () => {}
  };
};
const startTrackingEmbeddableUnsavedChanges = (uuid, parentApi, comparators, deserializeState) => {
  if (Object.keys(comparators).length === 0) return getDefaultDiffingApi();
  const lastSavedStateSubject = (0, _presentationContainers.getLastSavedStateSubjectForChild)(parentApi, uuid, deserializeState);
  if (!lastSavedStateSubject) return getDefaultDiffingApi();
  const comparatorSubjects = [];
  const comparatorKeys = [];
  for (const key of Object.keys(comparators)) {
    const comparatorSubject = comparators[key][0]; // 0th element of tuple is the subject
    comparatorSubjects.push(comparatorSubject);
    comparatorKeys.push(key);
  }
  const unsavedChanges = new _rxjs.BehaviorSubject((0, _presentationPublishing.runComparators)(comparators, comparatorKeys, lastSavedStateSubject === null || lastSavedStateSubject === void 0 ? void 0 : lastSavedStateSubject.getValue(), (0, _presentationPublishing.getInitialValuesFromComparators)(comparators, comparatorKeys)));
  const subscription = (0, _rxjs.combineLatest)(comparatorSubjects).pipe((0, _rxjs.debounceTime)(100), (0, _rxjs.map)(latestStates => comparatorKeys.reduce((acc, key, index) => {
    acc[key] = latestStates[index];
    return acc;
  }, {})), (0, _rxjs.combineLatestWith)(lastSavedStateSubject)).subscribe(([latestStates, lastSavedState]) => {
    unsavedChanges.next((0, _presentationPublishing.runComparators)(comparators, comparatorKeys, lastSavedState, latestStates));
  });
  return {
    unsavedChanges,
    resetUnsavedChanges: () => {
      const lastSaved = lastSavedStateSubject === null || lastSavedStateSubject === void 0 ? void 0 : lastSavedStateSubject.getValue();
      for (const key of comparatorKeys) {
        const setter = comparators[key][1]; // setter function is the 1st element of the tuple
        setter(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved[key]);
      }
    },
    cleanup: () => subscription.unsubscribe()
  };
};
exports.startTrackingEmbeddableUnsavedChanges = startTrackingEmbeddableUnsavedChanges;