"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelloWorldContainerComponent = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _embeddable_panel = require("../../../embeddable_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class HelloWorldContainerComponent extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "roots", {});
    (0, _defineProperty2.default)(this, "mounted", false);
    (0, _defineProperty2.default)(this, "inputSubscription", void 0);
    (0, _defineProperty2.default)(this, "outputSubscription", void 0);
    Object.values(this.props.container.getInput().panels).forEach(panelState => {
      this.roots[panelState.explicitInput.id] = /*#__PURE__*/_react.default.createRef();
    });
    this.state = {
      loaded: this.props.container.getOutput().embeddableLoaded,
      panels: this.props.container.getInput().panels
    };
  }
  async componentDidMount() {
    this.mounted = true;
    this.inputSubscription = this.props.container.getInput$().subscribe(() => {
      if (this.mounted) {
        this.setState({
          panels: this.props.container.getInput().panels
        });
      }
    });
    this.outputSubscription = this.props.container.getOutput$().subscribe(() => {
      if (this.mounted) {
        this.setState({
          loaded: this.props.container.getOutput().embeddableLoaded
        });
      }
    });
  }
  componentWillUnmount() {
    this.mounted = false;
    this.props.container.destroy();
    if (this.inputSubscription) {
      this.inputSubscription.unsubscribe();
    }
    if (this.outputSubscription) {
      this.outputSubscription.unsubscribe();
    }
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("h2", null, "HELLO WORLD! These are my precious embeddable children:"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, this.renderList()));
  }
  renderList() {
    const list = Object.values(this.state.panels).map(panelState => {
      const item = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: panelState.explicitInput.id
      }, /*#__PURE__*/_react.default.createElement(_embeddable_panel.EmbeddablePanel, {
        embeddable: () => this.props.container.untilEmbeddableLoaded(panelState.explicitInput.id)
      }));
      return item;
    });
    return list;
  }
}
exports.HelloWorldContainerComponent = HelloWorldContainerComponent;