"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterableContainer = exports.FILTERABLE_CONTAINER = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _containers = require("../../containers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FILTERABLE_CONTAINER = exports.FILTERABLE_CONTAINER = 'FILTERABLE_CONTAINER';

/**
 * interfaces are not allowed to specify a sub-set of the required types until
 * https://github.com/microsoft/TypeScript/issues/15300 is fixed so we use a type
 * here instead
 */

class FilterableContainer extends _containers.Container {
  constructor(initialInput, getFactory, parent) {
    super(initialInput, {
      embeddableLoaded: {}
    }, getFactory, parent);
    (0, _defineProperty2.default)(this, "type", FILTERABLE_CONTAINER);
  }
  getInheritedInput() {
    return {
      filters: this.input.filters,
      viewMode: this.input.viewMode
    };
  }
  render() {}
}
exports.FilterableContainer = FilterableContainer;