"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SlowContactCardEmbeddableFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _contact_card_embeddable = require("./contact_card_embeddable");
var _contact_card_embeddable_factory = require("./contact_card_embeddable_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class SlowContactCardEmbeddableFactory {
  constructor(options) {
    (0, _defineProperty2.default)(this, "loadTickCount", 0);
    (0, _defineProperty2.default)(this, "type", _contact_card_embeddable_factory.CONTACT_CARD_EMBEDDABLE);
    (0, _defineProperty2.default)(this, "create", async (initialInput, parent) => {
      for (let i = 0; i < this.loadTickCount; i++) {
        await Promise.resolve();
      }
      return new _contact_card_embeddable.ContactCardEmbeddable(initialInput, {
        execAction: this.options.execAction
      }, parent);
    });
    this.options = options;
    if (options.loadTickCount) {
      this.loadTickCount = options.loadTickCount;
    }
  }
  async isEditable() {
    return true;
  }
  getDisplayName() {
    return 'slow to load contact card';
  }
}
exports.SlowContactCardEmbeddableFactory = SlowContactCardEmbeddableFactory;