"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.editLegacyEmbeddable = exports.canEditEmbeddable = void 0;
var _rxjs = require("rxjs");
var _kibana_services = require("../../../kibana_services");
var _errors = require("../../errors");
var _embeddable_factory = require("../embeddable_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getExplicitInput = embeddable => {
  var _getInput$panels$embe, _embeddable$getRoot, _embeddable$getRoot$g, _embeddable$getRoot$g2, _embeddable$getRoot$g3;
  return (_getInput$panels$embe = (_embeddable$getRoot = embeddable.getRoot()) === null || _embeddable$getRoot === void 0 ? void 0 : (_embeddable$getRoot$g = _embeddable$getRoot.getInput()) === null || _embeddable$getRoot$g === void 0 ? void 0 : (_embeddable$getRoot$g2 = _embeddable$getRoot$g.panels) === null || _embeddable$getRoot$g2 === void 0 ? void 0 : (_embeddable$getRoot$g3 = _embeddable$getRoot$g2[embeddable.id]) === null || _embeddable$getRoot$g3 === void 0 ? void 0 : _embeddable$getRoot$g3.explicitInput) !== null && _getInput$panels$embe !== void 0 ? _getInput$panels$embe : embeddable.getInput();
};
const getAppTarget = async embeddable => {
  var _embeddable$getAppCon, _embeddable$getAppCon2;
  const app = embeddable ? embeddable.getOutput().editApp : undefined;
  const path = embeddable ? embeddable.getOutput().editPath : undefined;
  if (!app || !path) return;
  const currentAppId = await (0, _rxjs.firstValueFrom)(_kibana_services.core.application.currentAppId$);
  if (!currentAppId) return {
    app,
    path
  };
  const state = {
    originatingApp: currentAppId,
    valueInput: getExplicitInput(embeddable),
    embeddableId: embeddable.id,
    searchSessionId: embeddable.getInput().searchSessionId,
    originatingPath: (_embeddable$getAppCon = embeddable.getAppContext()) === null || _embeddable$getAppCon === void 0 ? void 0 : (_embeddable$getAppCon2 = _embeddable$getAppCon.getCurrentPath) === null || _embeddable$getAppCon2 === void 0 ? void 0 : _embeddable$getAppCon2.call(_embeddable$getAppCon)
  };
  return {
    app,
    path,
    state
  };
};
const editLegacyEmbeddable = async embeddable => {
  const {
    editableWithExplicitInput
  } = embeddable.getOutput();
  if (editableWithExplicitInput) {
    var _embeddable$parent;
    const factory = _kibana_services.embeddableStart.getEmbeddableFactory(embeddable.type);
    if (!factory) {
      throw new _errors.EmbeddableFactoryNotFoundError(embeddable.type);
    }
    const oldExplicitInput = embeddable.getExplicitInput();
    let newExplicitInput;
    try {
      const explicitInputReturn = await factory.getExplicitInput(oldExplicitInput, embeddable.parent);
      newExplicitInput = (0, _embeddable_factory.isExplicitInputWithAttributes)(explicitInputReturn) ? explicitInputReturn.newInput : explicitInputReturn;
    } catch (e) {
      // error likely means user canceled editing
      return;
    }
    (_embeddable$parent = embeddable.parent) === null || _embeddable$parent === void 0 ? void 0 : _embeddable$parent.replaceEmbeddable(embeddable.id, newExplicitInput);
    return;
  }
  const appTarget = await getAppTarget(embeddable);
  const stateTransfer = _kibana_services.embeddableStart.getStateTransfer();
  if (appTarget) {
    if (stateTransfer && appTarget.state) {
      await stateTransfer.navigateToEditor(appTarget.app, {
        path: appTarget.path,
        state: appTarget.state
      });
    } else {
      await _kibana_services.core.application.navigateToApp(appTarget.app, {
        path: appTarget.path
      });
    }
    return;
  }
  const href = embeddable.getOutput().editUrl;
  if (href) {
    window.location.href = href;
    return;
  }
};
exports.editLegacyEmbeddable = editLegacyEmbeddable;
const canEditEmbeddable = embeddable => {
  return Boolean(embeddable && embeddable.getInput().viewMode === 'edit' && embeddable.getOutput().editable && !embeddable.getOutput().inlineEditable && (embeddable.getOutput().editUrl || embeddable.getOutput().editApp && embeddable.getOutput().editPath || embeddable.getOutput().editableWithExplicitInput));
};
exports.canEditEmbeddable = canEditEmbeddable;