"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddPanelFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _eui = require("@elastic/eui");
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _kibana_services = require("../kibana_services");
var _lib = require("../lib");
var _saved_object_to_panel_methods = require("../registry/saved_object_to_panel_methods");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let lastToast;
const showSuccessToast = name => {
  if (lastToast) _kibana_services.core.notifications.toasts.remove(lastToast);
  lastToast = _kibana_services.core.notifications.toasts.addSuccess({
    title: _i18n.i18n.translate('embeddableApi.addPanel.savedObjectAddedToContainerSuccessMessageTitle', {
      defaultMessage: '{savedObjectName} was added',
      values: {
        savedObjectName: name
      }
    }),
    'data-test-subj': 'addObjectToContainerSuccess'
  });
};
const runAddTelemetry = (parentType, factory, savedObject) => {
  var _factory$savedObjectM, _usageCollection$repo;
  const type = (_factory$savedObjectM = factory.savedObjectMetaData) !== null && _factory$savedObjectM !== void 0 && _factory$savedObjectM.getSavedObjectSubType ? factory.savedObjectMetaData.getSavedObjectSubType(savedObject) : factory.type;
  _kibana_services.usageCollection === null || _kibana_services.usageCollection === void 0 ? void 0 : (_usageCollection$repo = _kibana_services.usageCollection.reportUiCounter) === null || _usageCollection$repo === void 0 ? void 0 : _usageCollection$repo.call(_kibana_services.usageCollection, parentType, _analytics.METRIC_TYPE.CLICK, `${type}:add`);
};
const AddPanelFlyout = ({
  container,
  onAddPanel
}) => {
  const factoriesBySavedObjectType = (0, _react.useMemo)(() => {
    return [..._kibana_services.embeddableStart.getEmbeddableFactories()].filter(embeddableFactory => {
      var _embeddableFactory$sa;
      return Boolean((_embeddableFactory$sa = embeddableFactory.savedObjectMetaData) === null || _embeddableFactory$sa === void 0 ? void 0 : _embeddableFactory$sa.type);
    }).reduce((acc, factory) => {
      acc[factory.savedObjectMetaData.type] = factory;
      return acc;
    }, {});
  }, []);
  const metaData = (0, _react.useMemo)(() => Object.values(factoriesBySavedObjectType).filter(embeddableFactory => Boolean(embeddableFactory.savedObjectMetaData) && !embeddableFactory.isContainerType).map(({
    savedObjectMetaData
  }) => savedObjectMetaData), [factoriesBySavedObjectType]);
  const onChoose = (0, _react.useCallback)(async (id, type, name, savedObject) => {
    const factoryForSavedObjectType = factoriesBySavedObjectType[type];
    if (!factoryForSavedObjectType) {
      throw new _lib.EmbeddableFactoryNotFoundError(type);
    }
    let embeddableId;
    if (_saved_object_to_panel_methods.savedObjectToPanel[type]) {
      // this panel type has a custom method for converting saved objects to panels
      const panel = _saved_object_to_panel_methods.savedObjectToPanel[type](savedObject);
      const {
        id: _embeddableId
      } = await container.addNewEmbeddable(factoryForSavedObjectType.type, panel, savedObject.attributes);
      embeddableId = _embeddableId;
    } else {
      const {
        id: _embeddableId
      } = await container.addNewEmbeddable(factoryForSavedObjectType.type, {
        savedObjectId: id
      }, savedObject.attributes);
      embeddableId = _embeddableId;
    }
    onAddPanel === null || onAddPanel === void 0 ? void 0 : onAddPanel(embeddableId);
    showSuccessToast(name);
    runAddTelemetry(container.type, factoryForSavedObjectType, savedObject);
  }, [container, factoriesBySavedObjectType, onAddPanel]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('embeddableApi.addPanel.Title', {
    defaultMessage: 'Add from library'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    services: {
      contentClient: _kibana_services.contentManagement.client,
      savedObjectsTagging: _kibana_services.savedObjectsTaggingOss === null || _kibana_services.savedObjectsTaggingOss === void 0 ? void 0 : _kibana_services.savedObjectsTaggingOss.getTaggingApi(),
      uiSettings: _kibana_services.core.uiSettings
    },
    onChoose: onChoose,
    savedObjectMetaData: metaData,
    showFilter: true,
    noItemsMessage: _i18n.i18n.translate('embeddableApi.addPanel.noMatchingObjectsMessage', {
      defaultMessage: 'No matching objects found.'
    }),
    getTooltipText: item => {
      return item.managed ? _i18n.i18n.translate('embeddableApi.addPanel.managedPanelTooltip', {
        defaultMessage: 'Elastic manages this panel. Adding it to a dashboard unlinks it from the library.'
      }) : undefined;
    }
  })));
};
exports.AddPanelFlyout = AddPanelFlyout;