"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasAIAssistantLicense = exports.getPluginNameFromRequest = exports.getMessageFromRawResponse = exports.UPGRADE_LICENSE_MESSAGE = exports.DEFAULT_PLUGIN_NAME = void 0;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PLUGIN_NAME = exports.DEFAULT_PLUGIN_NAME = 'securitySolutionUI';

/**
 * Attempts to extract the plugin name the request originated from using the request headers.
 *
 * Note from Kibana Core: This is not a 100% fit solution, though, because plugins can run in the background,
 * or even use other plugins’ helpers (ie, APM can use the infra helpers to call a third plugin)
 *
 * Should suffice for our purposes here with where the Elastic Assistant is currently used, but if needing a
 * dedicated solution, the core folks said to reach out.
 *
 * @param logger optional logger to log any errors
 * @param defaultPluginName default plugin name to use if unable to determine from request
 * @param request Kibana Request
 *
 * @returns plugin name
 */
const getPluginNameFromRequest = ({
  logger,
  defaultPluginName,
  request
}) => {
  try {
    const contextHeader = request.headers['x-kbn-context'];
    if (contextHeader != null) {
      var _JSON$parse;
      return (_JSON$parse = JSON.parse(decodeURIComponent(Array.isArray(contextHeader) ? contextHeader[0] : contextHeader))) === null || _JSON$parse === void 0 ? void 0 : _JSON$parse.name;
    }
  } catch (err) {
    logger === null || logger === void 0 ? void 0 : logger.error(`Error determining source plugin for selecting tools, using ${defaultPluginName}.`);
  }
  return defaultPluginName;
};
exports.getPluginNameFromRequest = getPluginNameFromRequest;
const getMessageFromRawResponse = ({
  rawContent,
  isError,
  traceData
}) => {
  const dateTimeString = new Date().toISOString();
  if (rawContent) {
    return {
      role: 'assistant',
      content: rawContent,
      timestamp: dateTimeString,
      isError,
      traceData
    };
  } else {
    return {
      role: 'assistant',
      content: 'Error: Response from LLM API is empty or undefined.',
      timestamp: dateTimeString,
      isError: true
    };
  }
};
exports.getMessageFromRawResponse = getMessageFromRawResponse;
const hasAIAssistantLicense = license => license.hasAtLeast(_constants.MINIMUM_AI_ASSISTANT_LICENSE);
exports.hasAIAssistantLicense = hasAIAssistantLicense;
const UPGRADE_LICENSE_MESSAGE = exports.UPGRADE_LICENSE_MESSAGE = 'Your license does not support AI Assistant. Please upgrade your license.';