"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAssistantToolParams = exports.REQUIRED_FOR_ATTACK_DISCOVERY = void 0;
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REQUIRED_FOR_ATTACK_DISCOVERY = exports.REQUIRED_FOR_ATTACK_DISCOVERY = [{
  id: (0, _uuid.v4)(),
  field: '_id',
  allowed: true,
  anonymized: true
}, {
  id: (0, _uuid.v4)(),
  field: 'kibana.alert.original_time',
  allowed: true,
  anonymized: false
}];
const getAssistantToolParams = ({
  alertsIndexPattern,
  anonymizationFields,
  esClient,
  langChainTimeout,
  latestReplacements,
  llm,
  onNewReplacements,
  request,
  size
}) => ({
  alertsIndexPattern,
  anonymizationFields: [...(anonymizationFields !== null && anonymizationFields !== void 0 ? anonymizationFields : []), ...REQUIRED_FOR_ATTACK_DISCOVERY],
  isEnabledKnowledgeBase: false,
  // not required for attack discovery
  chain: undefined,
  // not required for attack discovery
  esClient,
  langChainTimeout,
  llm,
  modelExists: false,
  // not required for attack discovery
  onNewReplacements,
  replacements: latestReplacements,
  request,
  size
});
exports.getAssistantToolParams = getAssistantToolParams;