"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.events = exports.KNOWLEDGE_BASE_EXECUTION_SUCCESS_EVENT = exports.KNOWLEDGE_BASE_EXECUTION_ERROR_EVENT = exports.INVOKE_ASSISTANT_SUCCESS_EVENT = exports.INVOKE_ASSISTANT_ERROR_EVENT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KNOWLEDGE_BASE_EXECUTION_SUCCESS_EVENT = exports.KNOWLEDGE_BASE_EXECUTION_SUCCESS_EVENT = {
  eventType: 'knowledge_base_execution_success',
  schema: {
    model: {
      type: 'keyword',
      _meta: {
        description: 'ELSER model used to execute the knowledge base query'
      }
    },
    resourceAccessed: {
      type: 'keyword',
      _meta: {
        description: 'Which knowledge base resource was accessed'
      }
    },
    resultCount: {
      type: 'long',
      _meta: {
        description: 'Number of documents returned from Elasticsearch'
      }
    },
    responseTime: {
      type: 'long',
      _meta: {
        description: `How long it took for Elasticsearch to respond to the knowledge base query`
      }
    }
  }
};
const KNOWLEDGE_BASE_EXECUTION_ERROR_EVENT = exports.KNOWLEDGE_BASE_EXECUTION_ERROR_EVENT = {
  eventType: 'knowledge_base_execution_error',
  schema: {
    model: {
      type: 'keyword',
      _meta: {
        description: 'ELSER model used to execute the knowledge base query'
      }
    },
    resourceAccessed: {
      type: 'keyword',
      _meta: {
        description: 'Which knowledge base resource was accessed'
      }
    },
    errorMessage: {
      type: 'keyword',
      _meta: {
        description: 'Error message from Elasticsearch'
      }
    }
  }
};
const INVOKE_ASSISTANT_SUCCESS_EVENT = exports.INVOKE_ASSISTANT_SUCCESS_EVENT = {
  eventType: 'invoke_assistant_success',
  schema: {
    isEnabledKnowledgeBase: {
      type: 'boolean',
      _meta: {
        description: 'Is Knowledge Base enabled'
      }
    },
    isEnabledRAGAlerts: {
      type: 'boolean',
      _meta: {
        description: 'Is RAG Alerts enabled'
      }
    },
    assistantStreamingEnabled: {
      type: 'boolean',
      _meta: {
        description: 'Is streaming enabled'
      }
    },
    actionTypeId: {
      type: 'keyword',
      _meta: {
        description: 'Kibana action type id'
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'LLM model',
        optional: true
      }
    }
  }
};
const INVOKE_ASSISTANT_ERROR_EVENT = exports.INVOKE_ASSISTANT_ERROR_EVENT = {
  eventType: 'invoke_assistant_error',
  schema: {
    errorMessage: {
      type: 'keyword',
      _meta: {
        description: 'Error message from Elasticsearch'
      }
    },
    isEnabledKnowledgeBase: {
      type: 'boolean',
      _meta: {
        description: 'Is Knowledge Base enabled'
      }
    },
    isEnabledRAGAlerts: {
      type: 'boolean',
      _meta: {
        description: 'Is RAG Alerts enabled'
      }
    },
    assistantStreamingEnabled: {
      type: 'boolean',
      _meta: {
        description: 'Is streaming enabled'
      }
    },
    actionTypeId: {
      type: 'keyword',
      _meta: {
        description: 'Kibana action type id'
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'LLM model',
        optional: true
      }
    }
  }
};
const events = exports.events = [KNOWLEDGE_BASE_EXECUTION_SUCCESS_EVENT, KNOWLEDGE_BASE_EXECUTION_ERROR_EVENT, INVOKE_ASSISTANT_SUCCESS_EVENT, INVOKE_ASSISTANT_ERROR_EVENT];