"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchEmbeddings = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _embeddings = require("@langchain/core/embeddings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Shell class for Elasticsearch embeddings as not needed in ElasticsearchStore since ELSER embeds on index
 */
class ElasticsearchEmbeddings extends _embeddings.Embeddings {
  constructor(logger, params) {
    super(params !== null && params !== void 0 ? params : {});
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = logger;
  }

  /**
   * TODO: Use inference API if not re-indexing to create embedding vectors, e.g.
   *
   * POST _ml/trained_models/.elser_model_2/_infer
   * {
   *   "docs":[{"text_field": "The fool doth think he is wise, but the wise man knows himself to be a fool."}]
   * }
   */

  embedDocuments(documents) {
    // Note: implement if/when needed
    this.logger.info('ElasticsearchEmbeddings.embedDocuments not implemented');
    return Promise.resolve([]);
  }
  embedQuery(_) {
    // Note: implement if/when needed
    this.logger.info('ElasticsearchEmbeddings.embedQuery not implemented');
    return Promise.resolve([]);
  }
}
exports.ElasticsearchEmbeddings = ElasticsearchEmbeddings;