"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PromptUpdateProps = exports.PromptResponse = exports.PromptDetailsInError = exports.PromptCreateProps = exports.PerformBulkActionResponse = exports.PerformBulkActionRequestBody = exports.NormalizedPromptError = exports.BulkCrudActionSummary = exports.BulkCrudActionResults = exports.BulkCrudActionResponse = exports.BulkActionSkipResult = exports.BulkActionSkipReason = exports.BulkActionBase = void 0;
var _zod = require("zod");
var _common_attributes = require("../conversations/common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Bulk Actions API endpoint
 *   version: 1
 */

const BulkActionSkipReason = exports.BulkActionSkipReason = _zod.z.literal('PROMPT_FIELD_NOT_MODIFIED');
const BulkActionSkipResult = exports.BulkActionSkipResult = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional(),
  skip_reason: BulkActionSkipReason
});
const PromptDetailsInError = exports.PromptDetailsInError = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional()
});
const NormalizedPromptError = exports.NormalizedPromptError = _zod.z.object({
  message: _zod.z.string(),
  status_code: _zod.z.number().int(),
  err_code: _zod.z.string().optional(),
  prompts: _zod.z.array(PromptDetailsInError)
});
const PromptResponse = exports.PromptResponse = _zod.z.object({
  id: _common_attributes.UUID,
  timestamp: _common_attributes.NonEmptyString.optional(),
  name: _zod.z.string(),
  promptType: _zod.z.string(),
  content: _zod.z.string(),
  isNewConversationDefault: _zod.z.boolean().optional(),
  isDefault: _zod.z.boolean().optional(),
  isShared: _zod.z.boolean().optional(),
  updatedAt: _zod.z.string().optional(),
  updatedBy: _zod.z.string().optional(),
  createdAt: _zod.z.string().optional(),
  createdBy: _zod.z.string().optional(),
  users: _zod.z.array(_common_attributes.User).optional(),
  /**
   * Kibana space
   */
  namespace: _zod.z.string().optional()
});
const BulkCrudActionResults = exports.BulkCrudActionResults = _zod.z.object({
  updated: _zod.z.array(PromptResponse),
  created: _zod.z.array(PromptResponse),
  deleted: _zod.z.array(_zod.z.string()),
  skipped: _zod.z.array(BulkActionSkipResult)
});
const BulkCrudActionSummary = exports.BulkCrudActionSummary = _zod.z.object({
  failed: _zod.z.number().int(),
  skipped: _zod.z.number().int(),
  succeeded: _zod.z.number().int(),
  total: _zod.z.number().int()
});
const BulkCrudActionResponse = exports.BulkCrudActionResponse = _zod.z.object({
  success: _zod.z.boolean().optional(),
  status_code: _zod.z.number().int().optional(),
  message: _zod.z.string().optional(),
  prompts_count: _zod.z.number().int().optional(),
  attributes: _zod.z.object({
    results: BulkCrudActionResults,
    summary: BulkCrudActionSummary,
    errors: _zod.z.array(NormalizedPromptError).optional()
  })
});
const BulkActionBase = exports.BulkActionBase = _zod.z.object({
  /**
   * Query to filter promps
   */
  query: _zod.z.string().optional(),
  /**
   * Array of prompts IDs
   */
  ids: _zod.z.array(_zod.z.string()).min(1).optional()
});
const PromptCreateProps = exports.PromptCreateProps = _zod.z.object({
  name: _zod.z.string(),
  promptType: _zod.z.string(),
  content: _zod.z.string(),
  isNewConversationDefault: _zod.z.boolean().optional(),
  isDefault: _zod.z.boolean().optional(),
  isShared: _zod.z.boolean().optional()
});
const PromptUpdateProps = exports.PromptUpdateProps = _zod.z.object({
  id: _zod.z.string(),
  content: _zod.z.string().optional(),
  isNewConversationDefault: _zod.z.boolean().optional(),
  isDefault: _zod.z.boolean().optional(),
  isShared: _zod.z.boolean().optional()
});
const PerformBulkActionRequestBody = exports.PerformBulkActionRequestBody = _zod.z.object({
  delete: BulkActionBase.optional(),
  create: _zod.z.array(PromptCreateProps).optional(),
  update: _zod.z.array(PromptUpdateProps).optional()
});
const PerformBulkActionResponse = exports.PerformBulkActionResponse = BulkCrudActionResponse;