"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackDiscoveryPostResponse = exports.AttackDiscoveryPostRequestBody = exports.AttackDiscovery = void 0;
var _zod = require("zod");
var _bulk_crud_anonymization_fields_route = require("../anonymization_fields/bulk_crud_anonymization_fields_route.gen");
var _common_attributes = require("../conversations/common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Attack discovery API endpoint
 *   version: 1
 */

/**
 * An attack discovery generated from one or more alerts
 */

const AttackDiscovery = exports.AttackDiscovery = _zod.z.object({
  /**
   * The alert IDs that the attack discovery is based on
   */
  alertIds: _zod.z.array(_zod.z.string()),
  /**
   * Details of the attack with bulleted markdown that always uses special syntax for field names and values from the source data.
   */
  detailsMarkdown: _zod.z.string(),
  /**
   * A short (no more than a sentence) summary of the attack discovery featuring only the host.name and user.name fields (when they are applicable), using the same syntax
   */
  entitySummaryMarkdown: _zod.z.string(),
  /**
   * An array of MITRE ATT&CK tactic for the attack discovery
   */
  mitreAttackTactics: _zod.z.array(_zod.z.string()).optional(),
  /**
   * A markdown summary of attack discovery, using the same syntax
   */
  summaryMarkdown: _zod.z.string(),
  /**
   * A title for the attack discovery, in plain text
   */
  title: _zod.z.string()
});
const AttackDiscoveryPostRequestBody = exports.AttackDiscoveryPostRequestBody = _zod.z.object({
  alertsIndexPattern: _zod.z.string(),
  anonymizationFields: _zod.z.array(_bulk_crud_anonymization_fields_route.AnonymizationFieldResponse),
  connectorId: _zod.z.string(),
  actionTypeId: _zod.z.string(),
  langSmithProject: _zod.z.string().optional(),
  langSmithApiKey: _zod.z.string().optional(),
  model: _zod.z.string().optional(),
  replacements: _common_attributes.Replacements.optional(),
  size: _zod.z.number(),
  subAction: _zod.z.enum(['invokeAI', 'invokeStream'])
});
const AttackDiscoveryPostResponse = exports.AttackDiscoveryPostResponse = _zod.z.object({
  connector_id: _zod.z.string().optional(),
  alertsContextCount: _zod.z.number().optional(),
  attackDiscoveries: _zod.z.array(AttackDiscovery).optional(),
  replacements: _common_attributes.Replacements.optional(),
  status: _zod.z.string().optional(),
  trace_data: _common_attributes.TraceData.optional()
});