"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecuteConnectorResponse = exports.ExecuteConnectorRequestParams = exports.ExecuteConnectorRequestBody = void 0;
var _zod = require("zod");
var _common_attributes = require("../conversations/common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Execute Connector API endpoint
 *   version: 1
 */

const ExecuteConnectorRequestParams = exports.ExecuteConnectorRequestParams = _zod.z.object({
  /**
   * The connector's `id` value.
   */
  connectorId: _zod.z.string()
});
const ExecuteConnectorRequestBody = exports.ExecuteConnectorRequestBody = _zod.z.object({
  conversationId: _common_attributes.UUID.optional(),
  message: _zod.z.string().optional(),
  model: _zod.z.string().optional(),
  subAction: _zod.z.enum(['invokeAI', 'invokeStream']),
  actionTypeId: _zod.z.string(),
  alertsIndexPattern: _zod.z.string().optional(),
  allow: _zod.z.array(_zod.z.string()).optional(),
  allowReplacement: _zod.z.array(_zod.z.string()).optional(),
  isEnabledKnowledgeBase: _zod.z.boolean().optional(),
  isEnabledRAGAlerts: _zod.z.boolean().optional(),
  replacements: _common_attributes.Replacements,
  size: _zod.z.number().optional(),
  langSmithProject: _zod.z.string().optional(),
  langSmithApiKey: _zod.z.string().optional()
});
const ExecuteConnectorResponse = exports.ExecuteConnectorResponse = _zod.z.object({
  data: _zod.z.string(),
  connector_id: _zod.z.string(),
  status: _zod.z.string(),
  /**
   * Trace Data
   */
  trace_data: _zod.z.object({
    /**
     * Could be any string, not necessarily a UUID
     */
    transactionId: _zod.z.string().optional(),
    /**
     * Could be any string, not necessarily a UUID
     */
    traceId: _zod.z.string().optional()
  }).optional()
});