"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentViewModeToggle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _discoverUtils = require("@kbn/discover-utils");
var _constants = require("../../../common/constants");
var _use_discover_services = require("../../hooks/use_discover_services");
var _hits_counter = require("../hits_counter");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DocumentViewModeToggle = ({
  viewMode,
  isTextBasedQuery,
  prepend,
  stateContainer,
  setDiscoverViewMode
}) => {
  var _uiSettings$get;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    uiSettings
  } = (0, _use_discover_services.useDiscoverServices)();
  const isLegacy = (0, _react.useMemo)(() => (0, _discoverUtils.isLegacyTableEnabled)({
    uiSettings,
    isTextBasedQueryMode: isTextBasedQuery
  }), [uiSettings, isTextBasedQuery]);
  const includesNormalTabsStyle = viewMode === _constants.VIEW_MODE.AGGREGATED_LEVEL || isLegacy;
  const containerPadding = includesNormalTabsStyle ? euiTheme.size.s : 0;
  const containerCss = (0, _react2.css)`
    padding: ${containerPadding} ${containerPadding} 0 ${containerPadding};
  `;
  const tabsCss = (0, _react2.css)`
    .euiTab__content {
      line-height: ${euiTheme.size.xl};
    }
  `;
  const showViewModeToggle = (_uiSettings$get = uiSettings.get(_discoverUtils.SHOW_FIELD_STATISTICS)) !== null && _uiSettings$get !== void 0 ? _uiSettings$get : false;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    css: containerCss
  }, prepend && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            &:empty {
              display: none;
            }
          `
  }, prepend), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isTextBasedQuery || !showViewModeToggle ? /*#__PURE__*/_react.default.createElement(_hits_counter.HitsCounter, {
    mode: _hits_counter.HitsCounterMode.standalone,
    stateContainer: stateContainer
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "m",
    css: tabsCss,
    "data-test-subj": "dscViewModeToggle",
    bottomBorder: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: viewMode === _constants.VIEW_MODE.DOCUMENT_LEVEL,
    onClick: () => setDiscoverViewMode(_constants.VIEW_MODE.DOCUMENT_LEVEL),
    "data-test-subj": "dscViewModeDocumentButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.viewModes.document.label",
    defaultMessage: "Documents"
  }), /*#__PURE__*/_react.default.createElement(_hits_counter.HitsCounter, {
    mode: _hits_counter.HitsCounterMode.appended,
    stateContainer: stateContainer
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: viewMode === _constants.VIEW_MODE.AGGREGATED_LEVEL,
    onClick: () => setDiscoverViewMode(_constants.VIEW_MODE.AGGREGATED_LEVEL),
    "data-test-subj": "dscViewModeFieldStatsButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.viewModes.fieldStatistics.label",
    defaultMessage: "Field statistics"
  })))));
};
exports.DocumentViewModeToggle = DocumentViewModeToggle;