"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HitsCounterMode = exports.HitsCounter = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _types = require("../../application/types");
var _use_data_state = require("../../application/main/hooks/use_data_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
let HitsCounterMode = exports.HitsCounterMode = /*#__PURE__*/function (HitsCounterMode) {
  HitsCounterMode["standalone"] = "standalone";
  HitsCounterMode["appended"] = "appended";
  return HitsCounterMode;
}({});
const HitsCounter = ({
  mode,
  stateContainer
}) => {
  const totalHits$ = stateContainer.dataState.data$.totalHits$;
  const totalHitsState = (0, _use_data_state.useDataState)(totalHits$);
  const hitsTotal = totalHitsState.result;
  const hitsStatus = totalHitsState.fetchStatus;
  if (!hitsTotal && hitsStatus === _types.FetchStatus.LOADING) {
    return null;
  }
  const formattedHits = /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": hitsStatus === _types.FetchStatus.PARTIAL ? 'discoverQueryHitsPartial' : 'discoverQueryHits'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
    value: hitsTotal !== null && hitsTotal !== void 0 ? hitsTotal : 0
  }));
  const hitsCounterCss = (0, _react2.css)`
    display: inline-flex;
  `;
  const hitsCounterTextCss = (0, _react2.css)`
    overflow: hidden;
  `;
  const element = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    justifyContent: "center",
    alignItems: "center",
    className: "eui-textTruncate eui-textNoWrap",
    css: hitsCounterCss,
    "data-test-subj": "discoverQueryTotalHits"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "aria-live": "polite",
    css: hitsCounterTextCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textTruncate",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, hitsStatus === _types.FetchStatus.PARTIAL && (mode === HitsCounterMode.standalone ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.hitsCounter.partialHitsPluralTitle",
    defaultMessage: "\u2265{formattedHits} {hits, plural, one {result} other {results}}",
    values: {
      hits: hitsTotal,
      formattedHits
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.hitsCounter.partialHits",
    defaultMessage: "\u2265{formattedHits}",
    values: {
      formattedHits
    }
  })), hitsStatus !== _types.FetchStatus.PARTIAL && (mode === HitsCounterMode.standalone ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.hitsCounter.hitsPluralTitle",
    defaultMessage: "{formattedHits} {hits, plural, one {result} other {results}}",
    values: {
      hits: hitsTotal,
      formattedHits
    }
  }) : formattedHits)))), hitsStatus === _types.FetchStatus.PARTIAL && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    "aria-label": _i18n.i18n.translate('discover.hitsCounter.hitCountSpinnerAriaLabel', {
      defaultMessage: 'Final hit count still loading'
    })
  })));
  return mode === HitsCounterMode.appended ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' (', element, ')') : element;
};
exports.HitsCounter = HitsCounter;