"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFlyoutActions = void 0;
var _i18n = require("@kbn/i18n");
var _use_navigation_props = require("../../hooks/use_navigation_props");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useFlyoutActions = ({
  actions,
  ...props
}) => {
  var _actions$defaultActio, _actions$getActionIte, _actions$getActionIte2;
  const {
    dataView
  } = props;
  const {
    singleDocHref,
    contextViewHref,
    onOpenSingleDoc,
    onOpenContextView
  } = (0, _use_navigation_props.useNavigationProps)(props);
  const {
    viewSingleDocument = {
      disabled: false
    },
    viewSurroundingDocument = {
      disabled: false
    }
  } = (_actions$defaultActio = actions === null || actions === void 0 ? void 0 : actions.defaultActions) !== null && _actions$defaultActio !== void 0 ? _actions$defaultActio : {};
  const customActions = [...((_actions$getActionIte = actions === null || actions === void 0 ? void 0 : (_actions$getActionIte2 = actions.getActionItems) === null || _actions$getActionIte2 === void 0 ? void 0 : _actions$getActionIte2.call(actions)) !== null && _actions$getActionIte !== void 0 ? _actions$getActionIte : [])];
  const flyoutActions = [{
    id: 'singleDocument',
    enabled: !viewSingleDocument.disabled,
    dataTestSubj: 'docTableRowAction',
    iconType: 'document',
    href: singleDocHref,
    onClick: onOpenSingleDoc,
    label: _i18n.i18n.translate('discover.grid.tableRow.viewSingleDocumentLinkLabel', {
      defaultMessage: 'View single document'
    })
  }, {
    id: 'surroundingDocument',
    enabled: Boolean(!viewSurroundingDocument.disabled && dataView.isTimeBased() && dataView.id),
    dataTestSubj: 'docTableRowAction',
    iconType: 'documents',
    href: contextViewHref,
    onClick: onOpenContextView,
    label: _i18n.i18n.translate('discover.grid.tableRow.viewSurroundingDocumentsLinkLabel', {
      defaultMessage: 'View surrounding documents'
    }),
    helpText: _i18n.i18n.translate('discover.grid.tableRow.viewSurroundingDocumentsHover', {
      defaultMessage: 'Inspect documents that occurred before and after this document. Only pinned filters remain active in the Surrounding documents view.'
    })
  }, ...customActions];
  return {
    flyoutActions: flyoutActions.filter(action => action.enabled)
  };
};
exports.useFlyoutActions = useFlyoutActions;